//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.6-3 Page 332
//Title: Simultaneous Material and Energy Balance
//===================================================================
model Ex7_6_3
    //=============
    // Parameter Section
    parameter Real m_in (unit = "kg/h") = 1150 "Mass flow rate of turbine discharge";
    parameter Real Hcap1_in (unit = "kJ/kg") = 2676 "Specific enthalpy of turbine discharge"; //From steam tables
    parameter Real Hcap2_in (unit = "kJ/kg") = 3278 "Specific enthalpy of superheated steam input"; //From steam tables
    parameter Real Hcap_out (unit = "kJ/kg") = 3074 "Specific enthalpy of mixed output steam"; //From steam tables
    parameter Real Vcap (unit = "m^3 / kg") = 3.11 "Specific volume of superheated steam"; //From Table B.7
    
    //=============
    // Variable Section 	
    Real m1 (unit = "kg/s") "Mass flow rate of superheated steam input";
    Real m2 (unit = "kg/s") "Mass flow rate of output steam";
    Real delH (unit = "kJ") "Enthalpy change occuring in the boiler";
    Real Qdot (unit = "kJ/min") "Heat input required";
    Real Ws (unit = "kJ / min") "Work extracted from fluid";    
    Real delEp (unit = "kJ / min") "Change in potential energy of streams";    
    Real delEk (unit = "kJ / min") "Change in kinetic energy of streams";    
    Real Vdot (unit = "m^3/h") "Volumetric flow rate of steam";
    
    //=============
    // Equation Section 
    equation
        m_in + m1 = m2; //Mass balance
        Qdot - Ws = delH + delEk + delEp;
        Ws = 0;
        delEk = 0;
        delEp = 0;
        delH = m2 * Hcap_out - m_in * Hcap1_in - m1 * Hcap2_in;
        delH = 0;
        Vdot = m1 * Vcap;
        
end Ex7_6_3;