//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.7-1 Page 334
//Title: The Bernoulli Equation
//===================================================================
model Ex7_7_1
    //=============
    // Parameter Section
    parameter Real Vdot (unit = "L/min") = 20 "Volumetric flow rate of water";
    parameter Real d1 (unit = "cm") = 0.5 "Inlet pipe diameter";
    parameter Real d2 (unit = "cm") = 1 "Outlet pipe diameter";
    parameter Real delz (unit = "m") = 50 "Change in height";
    parameter Real P2 (unit = "atm") = 1 "Outlet pressure";
    import Modelica.Constants.pi;
    import Modelica.Constants.g_n;
    parameter Real ro (unit = "kg/m^3") = 1000 "Density of water";
    
    //=============
    // Variable Section 	
    Real P1 (unit = "bar") "Inlet pressure";
    Real delP (unit = "N/m^2") "Pressure drop";
    Real u1 (unit = "m/s") "Inlet flow velocity";
    Real u2 (unit = "m/s") "Outlet flow velocity";
    Real A1 (unit = "m^2") "Inlet pipe area";
    Real A2 (unit = "m^2") "Outlet pipe area";
    
    //=============
    // Equation Section 
    equation
        A1 = pi /4 * d1^2 / 1e4;
        A2 = pi /4 * d2^2 / 1e4;
        u1 = Vdot / A1 / 60 / 1e3;
        u2 = Vdot / A2 / 60 / 1e3;
        delP/ ro + (u2^2 - u1^2)/2 + g_n * delz = 0;
        delP = (P2*1.01325e5) - P1*1e5;
        
end Ex7_7_1;