//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.7-2 Page 335
//Title: Siphoning
//===================================================================
model Ex7_7_2
    //=============
    // Parameter Section
    parameter Real F_cap (unit = "ft lbf/ lbm") = 0.80 "Frictional loss in pipe";
    parameter Real V (unit = "gal") = 5 "Volume of gasoline";
    parameter Real delz (unit = "ft") = -2.5 "Difference in height";
    parameter Real P1 (unit = "atm") =1 "Inlet pressure";
    parameter Real P2 (unit = "atm") = 1 "Outlet pressure";
    parameter Real d (unit = "in") = 0.25 "ID of hose";
    parameter Real g (unit = "ft/s^2") = 32.174 "Acceleration due to gravity";    
    import Modelica.Constants.pi;
    parameter Real ro (unit = "lbm / ft^3") = 50 "Density of gasoline";
    
    //=============
    // Variable Section 	
    Real delP (unit = "atm") "Pressure drop";
    Real u1 (unit = "ft/s") "Inlet flow velocity";
    Real u2 (unit = "ft/s") "Outlet flow velocity";
    Real A (unit = "ft^2") "Pipe area";
    Real t (unit = "min") "Time required to drain";
    Real Vdot (unit = "ft^3 / s") "Volumetric flow rate of gasoline";
    
    //=============
    // Equation Section 
    equation
        delP/ g* ro + (u2^2 - u1^2)/2/g + delz + F_cap = 0;
        delP = P2 - P1;
        A = pi /4 * d^2 / 144; //Dividing by 144 to convert in^2 to ft^2
        u1 = 0;
        Vdot = u2 * A;
        t = V * 0.1337 / Vdot /60; // Multiplying by 0.1337 to convert gal to ft^3
        
end Ex7_7_2;