//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.1-1 Page 362
//Title: Energy Balance on a Condenser
//===================================================================
model Ex8_1_1
    //=============
    // Parameter Section
    parameter Real n_in (unit = "mol/s") = 100 "Inlet molar flow rate of gas";
    parameter Real n_g (unit = "mol/s") = 36.45 "Molar flow rate of outlet gas";
    parameter Real n_c (unit = "mol/s") = 63.55 "Molar flow rate of condensate";
    parameter Real x_in (unit = "mol Ac(v) / mol") = 0.669 "Mole fraction of acetone in feed";
    parameter Real x_g (unit = "mol Ac(v) / mol") = 0.092 "Mole fraction of acetone in leaving gas";
    parameter Real ro_ac (unit = "g/L") = 791 "Density of acetone"; //Table B.1 Page 628
    parameter Real MW_ac (unit = "g/mol") = 58.08 "Molar mass of acetone";
    parameter Real P1 (unit = "atm") = 1 "Initial pressure";
    parameter Real P2 (unit = "atm") = 5 "Final pressure";
    parameter Real T1 (unit = "degC") = 65 "Initial temperature";
    parameter Real T2 (unit = "degC") = 20 "Final temperature";
    parameter Real Tbp (unit = "degC") = 56 "Boiling point of acetone"; //Table B.1
    parameter Real delHv (unit = "kJ/mol") = 30.2 "Enthalpy of vaporisation of acetone"; //Table B.1
    
    //=============
    // Variable Section
    Real vcap_ac (unit = "L/mol") "Molar specific volume of acetone";
    Real vcap_N2 (unit = "L/mol") "Molar specific volume of nitrogen";
    Real H1_cap (unit = "kJ/mol") "Specific molar enthalpy of acetone in feed";
    Real H2_cap (unit = "kJ/mol") "Specific molar enthalpy of nitrogen in feed";
    Real H3_cap (unit = "kJ/mol") "Specific molar enthalpy of acetone vapour at outlet conditions";
    Real H4_cap (unit = "kJ/mol") "Specific molar enthalpy of nitrogen at outlet conditions";
    Real delH (unit = "kJ/s") "Enthalpy change";
    Real Qdot (unit = "kJ/s") "Heat required for the condenser";
    
    //=============
    // Equation Section 
    equation
        vcap_ac = MW_ac / ro_ac;
        vcap_N2 = 22.4; //1 mole ideal gas occupies 22.4 litres at STP
        H1_cap = (vcap_ac * (P1 - 5)) + ((0.123 *(Tbp - 20)) + (18.6e-5 /2 * (Tbp^2 - 20^2))) + delHv + ((0.07196 * (T1- Tbp)) + (20.10e-5 /2 * (T1^2-Tbp^2)) - (12.78e-8 /3 * (T1^3 - Tbp^3)) +(34.76e-12 /4 * (T1^4 - Tbp^4))); 
        //Table B.2 gives the formula for Cp and reference temperature and pressure are 20 degC and 5 atm for liquid acetone
        H2_cap = ((29e-3 * (T1 - 25)) + (0.2199e-5 /2 * (T1^2 - 25^2)) + (0.5723e-8 /3 * (T1^3 - 25^3)) - (2.871e-12 /4 * (T1^4 - 25^4)));
        //Table B.2 gives the formula for Cp and reference temperature and pressure are 25 degC and 1 atm for nitrogen
        H3_cap = ((0.123 *(Tbp - 20)) + (18.6e-5 /2 * (Tbp^2 - 20^2))) + delHv + ((0.07196 * (T2- Tbp)) + (20.10e-5 /2 * (T2^2-Tbp^2)) - (12.78e-8 /3 * (T2^3 - Tbp^3)) +(34.76e-12 /4 * (T2^4 - Tbp^4))); 
        H4_cap = ((29e-3 * (T2 - 25)) + (0.2199e-5 /2 * (T2^2 - 25^2)) + (0.5723e-8 /3 * (T2^3 - 25^3)) - (2.871e-12 /4 * (T2^4 - 25^4)));
        delH = (n_g * x_g * H3_cap) + (n_g * (1-x_g) * H4_cap) + (n_c * 0) - (n_in * x_in * H1_cap) - (n_in * (1-x_in) * H2_cap);
        Qdot = delH;
        
end Ex8_1_1;