//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.3-2 Page 369
//Title: Cooling of an Ideal Gas
//===================================================================
package Ex8_3_2
    model Ex8_3_2_2
        //=============
        // Parameter Section
        parameter Real a = 0.02900;
        parameter Real b = 0.2199e-5;
        parameter Real c = 0.5723e-8;
        parameter Real d = -2.871e-12;
        //Polynomial formula for specific heat are taken from Table B.2 Appendix B
        parameter Real T1 (unit = "degC") = 90 "Initial temperature";
        parameter Real T2 (unit = "degC") = 30 "Final temperature";
        import Modelica.Constants.R; //Universal Gas Constant
        parameter Real V (unit = "L") = 5 "Volume of nitrogen";
        parameter Real P (unit = "bar") = 3 "Pressure of nitrogen";
        
        //=============
        // Variable Section
        Real n (unit = "mol") "Moles of nitrogen";
        Real delUcap (unit = "kJ/kg") "Specific internal energy change";
        Real delU_dot (unit = "kJ") "internal energy change";
        Real Q (unit = "kJ") "Heat required";
        Real a_v "Zero order polynomial constant in expression for Cv";
        
        //=============
        // Equation Section 
        equation
            n = P * V / (R / 100) / (T1+273.15);
            a_v = a - (R/ 1e3); //Cv = Cp - R so only the coefficient of the zero order term gets changed
            delUcap = ((a_v* (T2 - T1)) + (b /2 * (T2^2 - T1^2)) + (c /3 * (T2^3 - T1^3)) + (d /4 * (T2^4 - T1^4)));
            //Above equation is the integrated equation with limits substituted
            delU_dot = n * delUcap;
            Q = delU_dot;
    end Ex8_3_2_2;
    //===================================================================
    
    model Ex8_3_2_1
        //=============
        // Parameter Section
        parameter Real a = 0.02900;
        parameter Real b = 0.2199e-5;
        parameter Real c = 0.5723e-8;
        parameter Real d = -2.871e-12;
        //Polynomial formula for specific heat are taken from Table B.2 Appendix B
        parameter Real n_dot (unit = "mol/min") = 100 "Molar flow rate of nitrogen";
        parameter Real T1 (unit = "degC") = 20 "Initial temperature";
        parameter Real T2 (unit = "degC") = 100 "Final temperature";
       
        //=============
        // Variable Section
        Real delHcap (unit = "kJ/kg") "Specific Enthalpy change";
        Real delH_dot (unit = "kJ/min") "Enthalpy  change";
        Real Q_dot (unit = "kJ/min") "Heat required";
        
        //=============
        // Equation Section 
        equation
            delHcap = ((a* (T2 - T1)) + (b /2 * (T2^2 - T1^2)) + (c /3 * (T2^3 - T1^3)) + (d /4 * (T2^4 - T1^4)));
            //Above equation is the integrated equation with limits substituted
            delH_dot = n_dot*delHcap;
            Q_dot = delH_dot;
    end Ex8_3_2_1;
    //===================================================================
    
end Ex8_3_2;
