//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.3-3 Page 371
//Title: Evaluation of delH Using Heat Capacities and Tabulated Enthalpies
//===================================================================
package Ex8_3_3
    model Ex8_3_3_1
        //=============
        // Parameter Section
        parameter Real a = 0.02894;
        parameter Real b = 0.4147e-5;
        parameter Real c = 0.3191e-8;
        parameter Real d = -1.965e-12;
        //Polynomial formula for specific heat are taken from Table B.2 Appendix B
        parameter Real n_dot (unit = "kmol/min") = 15 "Molar flow rate of air";
        parameter Real T1 (unit = "degC") = 430 "Initial temperature";
        parameter Real T2 (unit = "degC") = 100 "Final temperature";
       
        //=============
        // Variable Section
        Real delHcap (unit = "kJ/kmol") "Specific Enthalpy change";
        Real delH_dot (unit = "kW") "Enthalpy  change";
        Real Q_dot (unit = "kW") "Heat required";
                
        //=============
        // Equation Section 
        equation
            delHcap = ((a* (T2 - T1)) + (b /2 * (T2^2 - T1^2)) + (c /3 * (T2^3 - T1^3)) + (d /4 * (T2^4 - T1^4)));
            //Above equation is the integrated equation with limits substituted
            delH_dot = n_dot*delHcap;
            Q_dot = delH_dot * 1000 / 60;
            
    end Ex8_3_3_1;  
    //===================================================================
    model Ex8_3_3_2
        //=============
        // Parameter Section
        parameter Real n_dot (unit = "kmol/min") = 15 "Molar flow rate of air";
        parameter Real T1 (unit = "degC") = 430 "Initial temperature";
        parameter Real T2 (unit = "degC") = 100 "Final temperature";
        parameter Real Hcap_100 (unit = "kJ/mol") = 2.19 "Specific enthalpy of air at 100 degC";
        parameter Real Hcap_500 (unit = "kJ/mol") = 14.37 "Specific enthalpy of air at 500 degC";
        parameter Real Hcap_400 (unit = "kJ/mol") = 11.24 "Specific enthalpy of air at 400 degC";
        //The values of specific heat of air are taken from Table B.8 
        
        //=============
        // Variable Section
        Real Hcap_430 (unit = "kJ/mol") "Specific enthalpy of air at 430 degC";
        Real delHcap (unit = "kJ/kmol") "Specific Enthalpy change";
        Real delH_dot (unit = "kW") "Enthalpy  change";
        Real Q_dot (unit = "kW") "Heat required";
        
        //=============
        // Equation Section 
        equation
            Hcap_430 = Hcap_400 + (430 - 400)/(500-400) * (Hcap_500 - Hcap_400); //Linear interpolation
            delHcap = Hcap_100 - Hcap_430;
            //Above equation is the integrated equation with limits substituted
            delH_dot = n_dot*delHcap;
            Q_dot = delH_dot * 1000 / 60;
            
    end Ex8_3_3_2;  
    //===================================================================
end Ex8_3_3;
