//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.3-4 Page 373
//Title: Heat Capacity of a Mixture
//===================================================================
model Ex8_3_4
    //=============
    // Parameter Section
    parameter Real [4] const1 = {0.04937,13.92e-5,-5.816e-8,7.28e-12};
    parameter Real [4] const2 = {0.06803,22.59e-5,-13.11e-8,31.71e-12};
    //Variables with nomenclature 1 are for ethane and 2 propane
    //Polynomial formula for specific heat are taken from Table B.2 Appendix B
    parameter Real x1 = 0.6 "Mole fraction of ethane in feed";
    parameter Real x2 = 0.4 "Mole fraction of propane in feed";
    parameter Real T1 (unit = "degC") = 0 "Initial temperature";
    parameter Real T2 (unit = "degC") = 400 "Final temperature";
    parameter Real n_dot (unit = "mol/h") = 150 "Molar flow rate of mixture";
    
    //=============
    // Variable Section    
    Real [4] const; //Polynomial coefficients for Cp
    Real delHcap (unit = "kJ/kg") "Specific Enthalpy change";
    Real delH_dot (unit = "kJ/h") "Enthalpy  change";
    Real Q_dot (unit = "kJ/h") "Heat required";
    
    //=============
    // Equation Section 
    equation
        for i in 1:4 loop
           const[i] = x1* const1[i] + x2* const2[i];
        end for;
        delHcap = ((const[1]* (T2 - T1)) + (const[2] /2 * (T2^2 - T1^2)) + (const[3] /3 * (T2^3 - T1^3)) + (const[4] /4 * (T2^4 - T1^4)));
        //Above equation is the integrated equation with limits substituted
        delH_dot = n_dot * delHcap;
        Q_dot = delH_dot;
end Ex8_3_4;
//===================================================================