//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.3-6 Page 375
//Title: Energy Balance on a Waste Heat Boiler
//===================================================================
model Ex8_3_6
    //=============
    // Parameter Section
    parameter Real [4] const1 = {0.02895, 0.4110e-5, 0.3548e-8,-2.22e-12}; //Polynomial coefficients for carbon monoxide
    parameter Real [4] const2 = {0.03611, 4.223e-5, -2.887e-8, 7.464e-12}; //Polynomial coefficients for carbon dioxide
    //Polynomial formula for specific heat are taken from Table B.2 Appendix B
    parameter Real x1 = 0.08 "Mole fraction of CO in feed";
    parameter Real x2 = 0.92 "Mole fraction of CO2 in feed";
    parameter Real n_g (unit ="mol")= 1 "Moles of gas";
    parameter Real n_l (unit ="mol")= 0.2 "Moles of water";
    parameter Real T1 (unit = "degC") = 500 "Initial temperature";
    
    //=============
    // Variable Section
    Real T (unit = "degC", start = 100) "Final temperature of gas stream";
    Real m_l (unit = "kg") "Mass of water";   
    Real H1cap (unit = "kJ/mol") "Specific Enthalpy of CO at outlet";
    Real H2cap (unit = "kJ/mol") "Specific Enthalpy of CO2 at outlet";
    Real H3cap (unit = "kJ/kg") "Specific Enthalpy of water at inlet";
    Real H4cap (unit = "kJ/kg") "Specific Enthalpy of steam at outlet";

    //=============
    // Equation Section 
    equation
        m_l = n_l * 18 / 1000;
        H1cap = ((const1[1]* (T - T1)) + (const1[2] /2 * (T^2 - T1^2)) + (const1[3] /3 * (T^3 - T1^3)) + (const1[4] /4 * (T^4 - T1^4)));
        H2cap = ((const2[1]* (T - T1)) + (const2[2] /2 * (T^2 - T1^2)) + (const2[3] /3 * (T^3 - T1^3)) + (const2[4] /4 * (T^4 - T1^4)));
        H3cap = 105; //From table B.5
        H4cap = 2747.5; //From table B.6
        //Above equation is the integrated equation with limits substituted
        (H3cap - H4cap)*m_l = n_g * x1 * H1cap + n_g* x2 * H2cap;
        
end Ex8_3_6;
//===================================================================