//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-1 Page 379
//Title: Heat of Vaporisation
//===================================================================
model Ex8_4_1
    //=============
    // Parameter Section
    parameter Real m_dot (unit = "g/min") = 1500 "Mass flow rate of methanol";
    parameter Real MW (unit = "g/mol") = 32 "Molar mass of methanol";
    //=============
    // Variable Section
    Real delHcap_v (unit = "kJ/mol") "Enthalpy of vaporisation of methanol";
    Real Q_dot (unit = "kW") "Required heat rate";
    
    //=============
    // Equation Section 
    equation
        delHcap_v = 35.3; //From Table B.1
        Q_dot = delHcap_v * m_dot / MW / 60;
end Ex8_4_1;
//===================================================================