//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.2-1 Page 446
//Title: Hess's Law
//===================================================================
model Ex9_2_1
    //=============
    // Parameter Section
    parameter Real delHcap_r1_o (unit = "kJ/mol") = -1559.8 "Standard Enthalpy of reaction 1";
    parameter Real delHcap_r2_o (unit = "kJ/mol") = -393.5 "Standard Enthalpy of reaction 2";
    parameter Real delHcap_r3_o (unit = "kJ/mol") = -285.8 "Standard Enthalpy of reaction 3";
    
    //=============
    // Variable Section
    Real delHcap_r4_o (unit = "kJ/mol") "Standard Enthalpy of reaction 4";
    
    //=============
    // Equation Section 
    equation
         delHcap_r4_o = 2*delHcap_r2_o - delHcap_r1_o + 3*delHcap_r3_o;
         
end Ex9_2_1;