//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.5-1 Page 453
//Title: Energy Balance About an Ammonia Oxidizer
//===================================================================
model Ex9_5_1
    //Reaction given is 4 N2 + 5 O2 -> 4 NO + 6 H2O
    //=============
    // Parameter Section
    parameter Real delHcap_r (unit = "kJ/mol") = -904.7 "Standard Enthalpy of reaction";
    parameter Real ndot_in_NH3 (unit = "mol/s") = 100 "Inlet mole rate of NH3";
    parameter Real ndot_in_O2 (unit = "mol/s") = 200 "Inlet mole rate of O2";
    parameter Real T_in (unit = "degC") = 25 "Feed inlet temperature";
    parameter Real T_out (unit = "degC") = 300 "Product temperature";
    parameter Real ndot_out_NH3 (unit = "mol/s") = 0 "Outlet mole rate of NH3";
    parameter Real [4] const = {29.5e-3, 0.8188e-5, -0.2925e-8, 0.3652e-12}; //Polynomial coefficients for NO from Table B.2 page 637
    parameter Real nu_NH3 = 4 "Stoichiometric coefficient of CO2 in reaction"; //from the reaction
    
    //=============
    // Variable Section
    Real ndot_out_O2 (unit = "mol/s") "Outlet mole rate of O2";
    Real ndot_out_NO (unit = "mol/s") "Outlet mole rate of NO";
    Real ndot_out_H2O (unit = "mol/s") "Outlet mole rate of H2O";
    Real H1cap (unit = "kJ / mol") "Specific enthalpy of O2 at 300 degC";
    Real H2cap (unit = "kJ / mol") "Specific enthalpy of NO at 300 degC";
    Real H3cap (unit = "kJ / mol") "Specific enthalpy of H2O at 300 degC";
    Real delH_dot (unit = "kJ/s") "Rate of enthalpy change";
    Real epsilon_dot (unit = "mol/s") "Extent of reaction";
    Real Qdot (unit = "kW") "Heat required";
    
    //=============
    // Equation Section 
    equation
         ndot_out_O2 = ndot_in_O2 - (ndot_in_NH3 - ndot_out_NH3)/4*5;
         ndot_out_NO = (ndot_in_NH3 - ndot_out_NH3);
         ndot_out_H2O = (ndot_in_NH3 - ndot_out_NH3)*6/4;
         H1cap = 8.470; //From table B.8 page 652
         H2cap = ((const[1]* (T_out - 25)) + (const[2] /2 * (T_out^2 - 25^2)) + (const[3] /3 * (T_out^3 - 25^3)) + (const[4] /4 * (T_out^4 - 25^4)));
         H3cap = 9.570; //From table B.8 page 652
         epsilon_dot = (ndot_in_NH3 - ndot_out_NH3) / nu_NH3;
         delH_dot = epsilon_dot * delHcap_r + ndot_out_O2*H1cap + ndot_out_NO*H2cap + ndot_out_H2O*H3cap;
         Qdot = delH_dot;
         
end Ex9_5_1;