//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.5-4 Page 458
//Title: Simultaneous Energy and Material Balances
//===================================================================
model Ex9_5_4
    //Reaction given is C2H5OH -> CH3CHO + H2
    //=============
    // Parameter Section
    parameter Real [4] cp_CH3CHO = {0.05048, 1.326e-4, -8.050e-8, 2.38e-11} "Polynomial coefficients of Cp of CH3CHO"; //Table B.2 page 636
    parameter Real [4] cp_C2H5OH = {61.34e-3, 15.72e-5, -8.749e-8, 19.83e-12} "Polynomial coefficients of Cp of C2H5OH"; //Table B.2 page 636
    parameter Real [4] cp_H2 = {28.24e-3, 0.00765e-5, 0.3288e-8, -0.8698e-12} "Polynomial coefficients of Cp of H2"; //Table B.2 page 636
    parameter Real x_in_C2H5OH = 0.9 "Inlet mole fraction of C2H5OH";
    parameter Real T_in (unit = "degC") = 300 "Inlet temperature";
    parameter Real n_in (unit = "mol/s") = 150 "Inlet mole flow rate";
    parameter Real x_in_CH3CHO = 0.1 "Inlet mole fraction of CH3CHO";
    parameter Real delHf_C2H5OH (unit = "kJ/mol") = -235.31 "Standard enthalpy of formation of C2H5OH";
    parameter Real delHf_CH3CHO (unit = "kJ/mol") = -166.2 "Standard enthalpy of formation of CH3CHO";
    parameter Real delHf_H2 (unit = "kJ/mol") = 0 "Standard enthalpy of formation of H2";
    parameter Real T_out (unit = "degC") = 253 "Outlet temperature";
    parameter Real Q_dot (unit = "kW") = 2440 "Heat supplied to reactor";
    
    //=============
    // Variable Section
    Real H1cap (unit = "kJ/mol") "Specific enthalpy of C2H5OH at inlet";
    Real H2cap (unit = "kJ/mol") "Specific enthalpy of C2H5OH at outlet";
    Real H3cap (unit = "kJ/mol") "Specific enthalpy of CH3CHO at outlet";
    Real H4cap (unit = "kJ/mol") "Specific enthalpy of H2 at outlet";
    Real H5cap (unit = "kJ/mol") "Specific enthalpy of CH3CHO at inlet";
    Real ndot_1 (unit = "mol/s") "Outlet mole flow rate of C2H5OH";
    Real ndot_2 (unit = "mol/s") "Outlet mole flow rate of CH3CHO";
    Real ndot_3 (unit = "mol/s") "Outlet mole flow rate of H2";
    Real x "Fractional conversion of ethanol";
    
    //=============
    // Equation Section
    equation
        H1cap = delHf_C2H5OH + (cp_C2H5OH[1] * (T_in - 25)) + (cp_C2H5OH[2]/2 * (T_in^2 - 25^2)) + (cp_C2H5OH[3]/3 * (T_in^3 - 25^3)) + (cp_C2H5OH[4]/4 * (T_in^4 - 25^4)) ;
        H2cap = delHf_C2H5OH + (cp_C2H5OH[1] * (T_out - 25)) + (cp_C2H5OH[2]/2 * (T_out^2 - 25^2)) + (cp_C2H5OH[3]/3 * (T_out^3 - 25^3)) + (cp_C2H5OH[4]/4 * (T_out^4 - 25^4)) ;
        H3cap = delHf_CH3CHO + (cp_CH3CHO[1] * (T_out - 25)) + (cp_CH3CHO[2]/2 * (T_out^2 - 25^2)) + (cp_CH3CHO[3]/3 * (T_out^3 - 25^3)) + (cp_CH3CHO[4]/4 * (T_out^4 - 25^4)) ;
        H4cap = delHf_H2 + (cp_H2[1] * (T_out - 25)) + (cp_H2[2]/2 * (T_out^2 - 25^2)) + (cp_H2[3]/3 * (T_out^3 - 25^3)) + (cp_H2[4]/4 * (T_out^4 - 25^4)) ;
        H5cap = delHf_CH3CHO + (cp_CH3CHO[1] * (T_in - 25)) + (cp_CH3CHO[2]/2 * (T_in^2 - 25^2)) + (cp_CH3CHO[3]/3 * (T_in^3 - 25^3)) + (cp_CH3CHO[4]/4 * (T_in^4 - 25^4)) ;
        n_in  = ndot_1 + ndot_2; //Carbon balance
        3*ndot_1 + 2*ndot_2 + ndot_3 = (x_in_C2H5OH * 6 + x_in_CH3CHO * 4) * n_in /2; //Hydrogen molecule Balance
        x = (x_in_C2H5OH * n_in - ndot_1) / (x_in_C2H5OH * n_in) ;
        Q_dot = (ndot_1 * H2cap) + (ndot_2 * H3cap) + (ndot_3 * H4cap) - (n_in * x_in_C2H5OH * H1cap) - (n_in * x_in_CH3CHO * H5cap); //Energy balance
                
end Ex9_5_4;