//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.5-5 Page 460
//Title: Standard Heat of a Neutralisation Reaction
//===================================================================
package Ex9_5_5
    model Ex9_5_5_1
        //Reaction given is H3PO4 + 3 NaOH -> Na3PO4 + 3H2O
        //=============
        // Parameter Section
        parameter Real delHf_H3PO4_aq (unit = "kcal/mol") = -309.3 "Enthalpy of formation of aqueous H3PO4"; //Page 2-189 Perry's Chemical Engineer's Handbook
        parameter Real delHf_Na3PO4_aq (unit = "kcal/mol") = -471.9 "Enthalpy of formation of aqeuous Na3PO4"; //Page 2-193 Perry's Chemical Engineer's Handbook
        parameter Real delHf_NaOH (unit = "kJ/mol") = -426.6 "Enthalpy of formation of NaOH"; //Table B.1 page 633
        parameter Real delHs (unit = "kcal/mol") = -42.51 "Heat of solution"; //Table B.11 page 653
        parameter Real delHf_H2O (unit = "kJ/mol") = -285.8 "Enthalpy of formation of aqeuous Na3PO4"; //Table B.1 page 635
        
        //=============
        // Variable Section
        Real delHr (unit = "kJ/mol") "Enthalpy of neutralisation reaction";
        Real delHf_NaOH_aq (unit = "kJ/mol") "Enthalpy of formation of aqueous NaOH";
        
        //=============
        // Equation Section
        equation
            delHf_NaOH_aq = delHf_NaOH + delHs;
            delHr = (delHf_Na3PO4_aq * 4.1858) + 3*delHf_H2O - (delHf_H3PO4_aq * 4.1858) - 3*delHf_NaOH_aq;
            
    end Ex9_5_5_1; 
    //===================================================================
    
    model Ex9_5_5_2
        //Reaction given is H3PO4 + 3 NaOH -> Na3PO4 + 3H2O
        //=============
        // Parameter Section
        parameter Real delHf_H3PO4_aq (unit = "kcal/mol") = -309.3 "Enthalpy of formation of aqueous H3PO4"; //Page 2-189 Perry's Chemical Engineer's Handbook
        parameter Real delHf_Na3PO4_aq (unit = "kcal/mol") = -471.9 "Enthalpy of formation of aqeuous Na3PO4"; //Page 2-193 Perry's Chemical Engineer's Handbook
        parameter Real delHf_NaOH (unit = "kJ/mol") = -426.6 "Enthalpy of formation of NaOH"; //Table B.1 page 633
        parameter Real delHs (unit = "kcal/mol") = -42.51 "Heat of solution"; //Table B.11 page 653
        parameter Real delHf_H2O (unit = "kJ/mol") = -285.8 "Enthalpy of formation of aqeuous Na3PO4"; //Table B.1 page 635
        
        //=============
        // Variable Section
        Real delHr (unit = "kJ/mol") "Enthalpy of neutralisation reaction";
        Real delHf_NaOH_aq (unit = "kJ/mol") "Enthalpy of formation of aqueous NaOH";
        Real delH (unit = "kJ/mol") "Enthalpy change in dissolving 5 mol NaOH";
        
        //=============
        // Equation Section
        equation
            delHf_NaOH_aq = delHf_NaOH + delHs;
            delHr = (delHf_Na3PO4_aq * 4.1858) + 3*delHf_H2O - (delHf_H3PO4_aq * 4.1858) - 3*delHf_NaOH_aq;
            delH = delHr * 5 /3;
            
    end Ex9_5_5_2; 
    //===================================================================
end Ex9_5_5;
