//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.5-6 Page 461
//Title: Energy Balance on Neutralisation Process
//===================================================================
model Ex9_5_6
    //Reaction given is H2SO4 + NaOH -> Na2SO4 + 2H2O
    //=============
    // Parameter Section
    parameter Real basis (unit = "kg H2SO4") = 1000 "Basis in mass of H2SO4";
    parameter Real x1 = 0.1 "Mass fraction of H2SO4";
    parameter Real x2 = 0.2 "Mass fraction of NaOH";
                    
    //=============
    // Variable Section
    Real m (unit = "g") "Mass of product formed";
    Real m2 (unit = "g Na2SO4") "Mass of Na2SO4 produced"; 
    Real m1 (unit = "g NaOH") "Mass of NaOH required";
    Real m3 (unit = "g H2O") "Mass of NaOH produced";
    Real epsilon (unit = "mol") "Extent of reaction";
    Real nH2SO4 (unit = "mol") "Moles of H2SO4 reacted";
    Real r_H2SO4 (unit = "mol H2SO4 / mol H2O") "Ratio of water to sulphuric acid ";
    Real r_NaOH (unit = "mol H2SO4 / mol H2O") "Ratio of water to NaOH ";
    Real r_Na2SO4 (unit = "mol H2SO4 / mol H2O") "Ratio of water to Na2SO4 ";
    Real Cp_H2SO4 (unit = "J/kgdegC") "Specific heat of H2SO4";
    Real nHcap_H2SO4 (unit = "kJ");
    Real nHcap_NaOH (unit = "kJ");
    Real nHcap_Na2SO4 (unit = "kJ");
    Real Q (unit = "kJ") "Heat of the process";
    Real delHr (unit = "kJ/mol") "Enthalpy of the reaction";
    
    //=============
    // Equation Section
    equation
        //1000 g of 0.1% H2SO4 as basis
        basis * x1 * 32 / 98.1 = m2 * 32 / 142; //Balance for Sulphur
        x2 * m1 * 23 / 40 = 145 * 46 / 142; //Balance for sodium
        basis + m1 = m2 + m3; //Total mass balance
        m = m3 + m2;
        nH2SO4 = basis * x1 / 98;
        r_H2SO4 = (900 / 18) / (100/98);
        r_NaOH = ((0.8 * m1) / 18)/ (x2 * m1 / 40);
        r_Na2SO4 = (m3 / 18) / (m2 / 142);
        epsilon = nH2SO4 / 1;
        Cp_H2SO4 = 3.85; //From Table 2.217 page 2-185 Perry's Chemical Engineer's Handbook
        nHcap_H2SO4 = basis * Cp_H2SO4 * (40 - 25) /1000;
        nHcap_NaOH = 0;
        nHcap_Na2SO4 = m * 4.184 * (35 - 25) /1000;
        delHr = -1384 + (-285.84 * 2) - (-884.6) - (-468.1 * 2);
        Q = epsilon*delHr + nHcap_Na2SO4 - nHcap_H2SO4 - nHcap_NaOH;
                
end Ex9_5_6;