//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.6-2 Page 467
//Title: Calculation of an Adiabatic Flame Temperature
//===================================================================
model Ex9_6_2
    //=============
    // Parameter Section
    parameter Real n_O2_theoretical (unit = "mol") = 1.5 "Theoretical oxygen requirement";
    parameter Real n_CH3OH (unit = "mol") = 1 "Moles of methanol fed";
    parameter Real [4] cp_CO2 = {0.03611, 4.233e-5, -2.887e-8, 7.464e-12} "Polynomial coefficients of Cp of CO2"; //Table B.2 page 636
    parameter Real [4] cp_H2O = {0.03346, 0.688e-5, 0.7604e-8, -3.593e-12} "Polynomial coefficients of Cp of CH3CHO"; //Table B.2 page 636
    parameter Real [4] cp_O2 = {0.02910, 1.158e-5, -0.6076e-8, 1.311e-12} "Polynomial coefficients of Cp of CH3CHO"; //Table B.2 page 636
    parameter Real [4] cp_N2 = {0.029, 0.2199e-5, 0.5723e-8, -2.871e-12} "Polynomial coefficients of Cp of CH3CHO"; //Table B.2 page 636
    parameter Real delHv_H2O (unit = "kJ/mol") = 44.013 "Heat of vapourisation of water";
    parameter Real delHc (unit = "kJ/mol") = -726.6 "Heat of combustion";
                
    //=============
    // Variable Section
    Real n1 (unit = "mol") "Moles of O2";
    Real n2 (unit = "mol") "Moles of CO2 formed";
    Real n3 (unit = "mol") "Moles of H2O formed";    
    Real n4 (unit = "mol") "Moles of O2 in exhaust";
    Real n5 (unit = "mol") "Moles of N2 in exhaust";
    Real delHcap_CH3OH (unit = "kJ/mol") "Methanol feed enthalpy";
    Real delHcap_air (unit = "kJ/mol") "Air feed enthalpy";
    Real [4] nicpi "Summed specific heat coefficients";
    Real T_ad (unit = "degC", start = 100) "Adiabatic flame temperature";
    
    //=============
    // Algorithm Section
    algorithm
        for i in 1:4 loop
            nicpi [i] := n2*cp_CO2[i] + n3*cp_H2O[i] + n4*cp_O2[i] + n5*cp_N2[i];
        end for;
        
    //=============
    // Equation Section
    equation
        n1 = 2 * n_O2_theoretical;
        n5 = n1 / 0.21 * 0.79;
        n_CH3OH = n2; //Carbon balance
        n_CH3OH * 4 = n3 * 2; //Hydrogen balance
        n4 = n1- n_O2_theoretical;
        delHcap_air = 2.191; //Table B.8
        delHcap_CH3OH = 0;
        (n3 * delHv_H2O) + ((nicpi[1] * (T_ad - 25)) + (nicpi[2]/2 * (T_ad^2 - 25^2)) + (nicpi[3]/3 * (T_ad^3 - 25^3)) + (nicpi[4]/4 * (T_ad^4 - 25^4))) = (-n_CH3OH * delHc) + (n_CH3OH * delHcap_CH3OH) + (n1 / 0.21 * delHcap_air);
                                
end Ex9_6_2;                
//===================================================================