//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-2: Introduction to Engineering Calculations
//Example: 2.5-2 Page 19
//Title: Statistical Quality Control
//===================================================================
model Ex2_5_2
    //=============
    // Parameter Section
    parameter Real[12] Week = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12} "Week number";
    parameter Real[12] Y = {17, 27, 18, 18, 23, 19, 18, 21, 20, 19, 21, 18} "Number of bad batches produced per week";
    //=============
    // Variable Section
    Real sigmaY(unit = "batches/week", start=0) "Sum of all Y terms";
    Real Ybar(unit = "batches/week", start=0) "Sample mean";
    Real s2y(unit = "(batches/week)^2", start=0) "Sample variance";
    Real sy(unit = "batches/week", start=0) "Sample standard deviation";
    Real y_limit_1(unit = "batches/week", start=0) "Limiting value of Y for the inequality Y =< Ybar + 3 sy";
    Real y_limit_2(unit = "batches/week", start=0) "Limiting value of Y for the inequality Y =< Ybar + 2 sy";
    //=============
    //Algorithm section
    algorithm
      for i in 1:12 loop
        sigmaY := (sigmaY) + Y[i];
      end for;
      Ybar := sigmaY / 12;
      for i in 1:12 loop
        s2y := s2y + (Y[i] - Ybar) ^ 2;
      end for;
      s2y := s2y / 11;
    
    //=============
    // Equation  Section
    equation
      sy = s2y ^ (1 / 2);
      y_limit_1 = Ybar + (3 * sy);
      y_limit_2 = Ybar + (2 * sy);
end Ex2_5_2;
//===================================================================