//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000

//Chapter-3: Processes and Process Variables
//Example: 3.3-3 Page 50
//Title: Conversion from a Composition by Mass to Molar Composition
//===================================================================
model Ex3_3_3
    //=============
    // Parameter Section 
    //The arrays are in the order O2, CO2, CO, N2
    parameter Real [4] xi = {0.16, 0.04, 0.17, 0.63} "Mass fractions";
    parameter Real basis =100 "Mass basis for the calculations";
    parameter Real [4] mw (unit= "g/mol") = {32, 28, 44, 28} "Molecular weights of the compounds";
    
    //=============
    // Variable Section 
    Real [4] mi (unit="g") "Mass of the compound";
    Real [4] ni (unit="mol") "Moles of the compound";
    Real [4] yi "Mole fraction of the compound";
    Real nT (unit="mol") "Total number of moles";
    
    //=============
    // Equation  Section 
    equation
        mi=xi.*basis;
        ni=mi./mw;
        nT=ni[1]+ni[2]+ni[3]+ni[4];
        yi=ni./nT;

end Ex3_3_3;