//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000

//Chapter-3: Processes and Process Variables
//Example: 3.3-5 Page 52
//Title: Conversion between Mass, Molar and Volumetric Flow Rates of a Solution
//===================================================================
package Ex3_3_5
    //=============
    
    model Ex3_3_5_1
        //=============
        // Parameter Section 
        parameter Real M (unit="mol H2SO4/ L") = 0.5 "Molarity of H2SO4 solution";
        parameter Real mw (unit = "g/ mol") = 98 "Molecular weight of H2SO4";
        
        //=============
        // Variable Section 
        Real c_H2SO4 (unit= "kg H2SO4/ m^3") "Mass concentration of H2SO4";
        
        //=============
        // Equation  Section 
        equation
          c_H2SO4 = M * mw / 10^3 * 10^3; //1 g = 1 / 10^3 kg and 1 m^3 = 10^3 L
          
    end Ex3_3_5_1;
    //=============
    
    model Ex3_3_5_2
        //=============
        // Parameter Section 
        parameter Real q (unit="m^3/ min") = 1.25 "volumetric flow rate of solution";
        parameter Real c_H2SO4 (unit= "kg H2SO4/ m^3") = 49 "Mass concentration of H2SO4";
        
        //=============
        // Variable Section 
        Real m_dot_H2SO4 (unit="kg/s") "Mass flow rate of H2SO4";
        
        //=============
        // Equation  Section 
        equation
          m_dot_H2SO4 = q * c_H2SO4 /60; //1 min = 60 s
          
    end Ex3_3_5_2;
    //=============
    
    model Ex3_3_5_3
        //=============
        // Parameter Section 
        parameter Real sp_g = 1.03 "Specific gravity of the solution";
        parameter Real q (unit="m^3/ min") = 1.25 "volumetric flow rate of solution";
        parameter Real m_dot_H2SO4 (unit="kg/s") = 1.0 "Mass flow rate of H2SO4";
        
        //=============
        // Variable Section 
        Real ro_solution (unit = "kg/m^3") "Density of solution";
        Real m_dot_solution (unit="kg/s") "Mass flow rate of solution";
        Real x_H2SO4 "Mass fraction of H2SO4";
        
        //=============
        // Equation  Section 
        equation
          ro_solution = sp_g * 1000; //Density of water = 1000 kg/m^3
          m_dot_solution = q * ro_solution / 60; //Dividing my 60 because 1 min = 60 s
          x_H2SO4 = m_dot_H2SO4 / m_dot_solution;
        
    end Ex3_3_5_3;
    //=============

end Ex3_3_5;
