//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-3: Processes and Process Variables
//Example: 3.4-3 Page 59
//Title: Pressure Measurement with Manometers
//===================================================================
package Ex3_4_3
    
    model Ex3_4_3_1
        //=============
        // Parameter Section 
        parameter Real ro (unit= "g/cm^3") = 1 "Density of process fluid";
        parameter Real ro_f (unit= "g/cm^3") = 1.05 "Density of manometer fluid";
        parameter Real g (unit = "cm /s^2") = 980.7 "Acceleration due to gravity";
        parameter Real h_1 (unit = "mm") = 374 "Measured level in arm 1";
        parameter Real h_2 (unit = "mm") = 382 "Measured level in arm 2";
        
        //=============
        // Variable Section 
        Real h (unit = "mm") "Difference in height of measured levels";
        Real delP (unit = "dynes/cm^2") "Difference in pressure between points 1 and 2";
        
        //=============
        // Equation  Section 
        equation
            h = h_2 - h_1;
            delP = (ro_f - ro) * g * h / 10; // conversion factor used is 1 cm = 10 mm

    end Ex3_4_3_1;
    //===================================================================
    model Ex3_4_3_2
        //=============
        // Parameter Section 
        parameter Real P_atm (unit="in. Hg") = 30 "Atmospheric pressure in inches of mercury";
        parameter Real P_gauge (unit="in. Hg") = -2 "Indicated reading"; //Negative sign indicates drop in pressure along the flow direction
        
        //=============
        // Variable Section 
        Real P_1 (unit = "in. Hg") "Gauge pressure of the process line in in. Hg";
        
        //=============
        // Equation  Section 
        equation
            P_1 - P_atm = P_gauge;
          
    end Ex3_4_3_2;
    
end Ex3_4_3;
