//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-3: Processes and Process Variables
//Example: 3.5-2 Page 62
//Title: Temperature Conversion
//===================================================================
package Ex3_5_2
    
    model Ex3_5_2_1
        //=============
        // Parameter Section 
        parameter Real T1_F (unit="degF") = 20 "Given temperature 1 in Fahrenheit";
        parameter Real T2_F (unit="degF") = 80 "Given temperature 2 in Fahrenheit";
        
        //=============
        // Variable Section 
        Real T1_C (unit="degC") "Temperature 1 in Celsius";
        Real T2_C (unit="degC") "Temperature 2 in Celsius";
        Real delT_C (unit="degC") "Temperature difference in Celsius";
        
        //=============
        // Equation  Section 
        equation
            T1_C = (T1_F - 32) / 1.8;
            T2_C = (T2_F - 32) / 1.8;
            delT_C = T2_C - T1_C;
          
    end Ex3_5_2_1;
    //===================================================================
    model Ex3_5_2_2
        //=============
        // Parameter Section 
        parameter Real T1_F (unit="degF") = 20 "Given temperature 1 in Fahrenheit";
        parameter Real T2_F (unit="degF") = 80 "Given temperature 2 in Fahrenheit";
        
        //=============
        // Variable Section 
        Real delT_C (unit="degC") "Temperature difference in Celsius";
        Real delT_F (unit="degF") "Temperature difference in Fahrenheit";
        
        //=============
        // Equation  Section 
        equation
            delT_F = T2_F - T1_F;
            delT_C = delT_F / 1.8;
                
    end Ex3_5_2_2;

end Ex3_5_2;
