//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.4-2 Page 105
//Title: Two Unit Processes
//===================================================================
model Ex4_4_2
    //=============
    // Parameter Section
    parameter Real mF (unit = "kg") = 100 "Mass of feed mixture";
    parameter Real xF (unit = "kg A/ kg") = 0.5 "Mass fraction of Acetone in feed";
    parameter Real mF_m1 (unit = "kg") = 100 "Mass of MIBK fed to 1st extractor";
    parameter Real mF_m2 (unit = "kg") = 75 "Mass of MIBK fed to 2nd extractor";
    parameter Real mP (unit = "kg") = 43.1 "Mass of product mixture";
    parameter Real xP_A (unit = "kg A/ kg") = 0.053 "Mass fraction of Acetone in product";
    parameter Real xP_M (unit = "kg M/ kg") = 0.016 "Mass fraction of MIBK in product";
    parameter Real x1A (unit = "kg A/ kg") = 0.275 "Mass fraction of Acetone in 1st raffinate";
    parameter Real x3A (unit = "kg A/ kg") = 0.09 "Mass fraction of Acetone in 2nd raffinate";
    parameter Real x3M (unit = "kg M/ kg") = 0.88 "Mass fraction of MIBK in 2nd raffinate";
    
   
    //=============
    // Variable Section 		
    Real m1 (unit = "kg") "Mass of extract from 1st extractor";
    Real x1M (unit = "kg M/ kg") "Mass fraction of MIBK in 1st extract";
    Real mA2 (unit = "kg") "Mass of acetone in 1st raffinate";
    Real mW2 (unit = "kg") "Mass of H2O in 1st raffinate";
    Real mM2 (unit = "kg") "Mass of MIBK in 1st raffinate";
    Real m3 (unit = "kg") "Mass of extract from 2nd extractor";
    Real mA4 (unit = "kg") "Mass of acetone in mixed raffinate";
    Real mW4 (unit = "kg") "Mass of H2O in mixed raffinate";
    Real mM4 (unit = "kg") "Mass of MIBK in mixed raffinate";
    //The following commented variables cannot be solved for due to insufficient equations
    //Real m5 (unit = "kg") "Mass of top product from distillation column";
    //Real mA6 (unit = "kg") "Mass of acetone in bottoms product";
    //Real mW6 (unit = "kg") "Mass of H2O in bottoms product";   
    //Real mM6 (unit = "kg") "Mass of MIBK in bottoms product";    
    
    //=============
    // Equation Section 
    equation
        mF * xF = mP * xP_A + m1 * x1A + m3 * x3A; //Acetone balance around 2 extractors
        mF + 100 + 75 = mP + m1 + m3; //Overall mass balance for 2 extractors
        100 + 75 = mP * xP_M + m1 * x1M + m3 * x3M; //MIBK balance for 2 extractors
        mA4 = m1 * x1A + m3 * x3A; //Acetone balance around mixing point
        mM4 = m1 * x1M + m3 * x3M; //MIBK balance around mixing point
        mW4 = m1 * (1- x1A - x1M) + m3 * (1 - x3A - x3M); //Water balance around mixing point
        mF * xF = mA2 + m1 * x1A; //1st extractor acetone balance
        100 = mM2 + m1 * x1M; //1st extractor MIBK balance
        mF * (1-xF) = mW2 + m1 * (1- x1A - x1M); //1st extractor water balance
        
                
        
end Ex4_4_2;
//===================================================================