//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.6-3 Page 124
//Title: Yield and Selectivity in a Dehydrogenation Reactor
//===================================================================
model Ex4_6_3
    //=============
    // Parameter Section
    parameter Real nf (unit = "mol") = 100 "Moles of feed";
    parameter Real xf = 0.85 "Mole fraction of ethane in feed";
    parameter Real f1 = 0.501 "Fractional conversion of ethane";
    parameter Real f2 = 0.471 "Fractional conversion of ethylene";
       
    //=============
    // Variable Section 		
    Real n1 (unit = "mol") "Moles of ethane in outlet";
    Real n2 (unit = "mol") "Moles of ethylene in outlet";
    Real n3 (unit = "mol") "Moles of hydrogen in outlet";
    Real n4 (unit = "mol") "Moles of methane in outlet";
    Real n5 (unit = "mol") "Moles of inert in outlet";
    Real epsilon1 (unit = "mol") "Extent of reaction 1";
    Real epsilon2 (unit = "mol") "Extent of reaction 2";
    Real ntot (unit = "mol") "total number of moles";
    Real y1 (unit = "%") "Mole percentage of ethane";
    Real y2 (unit = "%") "Mole percentage of ethylene";
    Real y3 (unit = "%") "Mole percentage of hydrogen";
    Real y4 (unit = "%") "Mole percentage of methane";
    Real y5 (unit = "%") "Mole percentage of inerts";
    Real selectivity "Selectivity of product";
    
    //=============
    // Equation Section 
    equation
        n1 = nf * xf - epsilon1 - epsilon2;
        n2 = epsilon1 ;
        n3 = epsilon1 - epsilon2;
        n4 = 2* epsilon2;
        n5 = nf * (1-xf);
        n1 = nf * xf * (1 - f1);
        n2 = nf * xf * f2;
        ntot = n1 + n2 + n3 + n4 + n5;
        y1 = n1 / ntot * 100;
        y2 = n2 / ntot* 100;
        y3 = n3 / ntot* 100;
        y4 = n4 / ntot* 100;
        y5 = n5 / ntot* 100;
        selectivity = n2/ n4;
        
end Ex4_6_3;
//===================================================================