//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.7-3 Page 139
//Title: Recycle and Purge in Synthesis of Methanol
//===================================================================
model Ex4_7_3
    //=============
    // Parameter Section
    parameter Real x0I (unit = "mol I / mol") = 0.004 "Feed mole fraction of inerts";
      
    //=============
    // Variable Section 		
    Real n0 (unit = "mol") "Moles of feed";
    Real x0C (unit = "mol CO2 / mol") "Feed mole fraction of CO2";
    Real n3 (unit = "mol CH3OH") "Moles of methanol in reactor effluent";
    Real x5C (unit = "mol CO2 / mol") "Mole fraction of CO2 in purge";
    Real x5H (unit = "mol H2 / mol") "Mole fraction of H2 in purge";
    Real np (unit = "mol") "Moles of purge stream";
    Real nr (unit = "mol") "Moles of recycle stream";
    Real n2 (unit = "mol H2") "Moles of H2 in reactor effluent";
    Real n1 (unit = "mol CO2") "Moles of CO2 in reactor effluent";
    Real n4 (unit = "mol H2O") "Moles of H2O in reactor effluent";
    Real n5 (unit = "mol") "Moles of vapour from condenser";
    Real f (unit = "kmol/h / mol") "Scaling factor";
    Real n0_s (unit = "kmol/h") "Scaled moles of feed";
    Real n_fr (unit = "kmol/h") "Scaled reactor feed rate";
    Real nr_s (unit = "kmol/h") "Scaled moles of recycle stream";
    Real np_s (unit = "kmol/h") "Scaled moles of purge stream";
    
    //=============
    // Equation Section 
    equation
        //Reactor balances
        n2 = 0.7 * 100 * (1-0.60); //60% conversion of Hydrogen in reactor
        n1 = (100 * 0.28) - ((0.7 * 100) - n2)/3; //CO2 balance
        n3 =  ((0.7 * 100) - n2)/3; //CH3OH balance
        n4 = ((0.7 * 100) - n2)/3; //H2O balance
        //Condenser balances
        n1 + n2 + n3 + n4 + (100 * 0.02) = n3 + n4 +n5; //Total mole balance
        n1 = n5 * x5C; //CO2 balance
        n2 = n5 * x5H; //H2 balance
        //Mixing point balances
        n0 + nr = 100;
        n0 * 0.004 + nr * 0.04545 = (100 * 0.02); //Inert balance
        n0 * x0C + nr * x5C = (100 * 0.28); //CO2 balance
        //Split point analysis
        n5 = nr + np; //Total mole balance
        //Scaling
        f = 155 / n3;
        n0_s = n0 * f;
        n_fr = 100 * f;
        nr_s = nr * f;
        np_s = np * f;
        
end Ex4_7_3 ;
//===================================================================