//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.4-3 Page 212
//Title: Kay's Rule
//===================================================================
model Ex5_4_3
    //=============
    // Parameter Section
    parameter Real y_N2 = 0.25 "Mole fraction of N2";
    parameter Real y_H2 = 0.75 "Mole fraction of H2";
    parameter Real R (unit = "Latm/molK") = 0.08206 "Gas constant";
    parameter Real Tc_H2 (unit ="K") = 33 "Critical temperature of H2 at given conditions"; //Taken from Table B.1
    parameter Real Pc_H2 (unit ="atm") = 12.8 "Critical pressure of H2 at given conditions"; //Taken from Table B.1
    parameter Real Tc_N2 (unit ="K") = 126.2 "Critical temperature of N2 at given conditions"; //Taken from Table B.1
    parameter Real Pc_N2 (unit ="atm") = 33.5 "Critical pressure of N2 at given conditions"; //Taken from Table B.1
    parameter Real P (unit = "atm") = 800 "Pressure of the tank";
    parameter Real T_c (unit = "degC") = -70 "Temperature in Kelvin";
    parameter Real zm = 1.86 "Compressibility of the mixture"; //Found using Tr_dash and Pr_dash values in Figure 5.4.4 page 211
    
    //=============
    // Variable Section
    Real T (unit = "K") "Temperature in Kelvin";
    Real V_cap (unit = "L/mol") "Molar volume of N2";
    Real Tc_H2_a (unit ="K") "Actual critical temperature of H2 at given conditions";
    Real Pc_H2_a (unit ="atm") "Actual critical pressure of H2 at given conditions"; 
    Real Tc_dash (unit = "K") "Pseudocritical temperature constant";
    Real Pc_dash (unit = "atm") "Pseudocritical pressure constant";
    Real Tr_dash "Reduced temperature";
    Real Pr_dash "Reduced pressure";
    
    //=============
    // Equation Section 
    equation
        T = T_c + 273.15;
        Tc_H2_a = Tc_H2 +8; //Newton's correction for Hydrogen and Helium
        Pc_H2_a = Pc_H2 +8; //Newton's correction for Hydrogen and Helium
        Tc_dash = (y_H2 * Tc_H2_a) + (y_N2 * Tc_N2);
        Pc_dash = (y_H2 * Pc_H2_a) + (y_N2 * Pc_N2);
        Tr_dash = T / Tc_dash;
        Pr_dash = T / Pc_dash;
        P*V_cap = zm * R *T;
        
end Ex5_4_3;
//===================================================================