//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.2-1 Page 248
//Title: The Gibbs Phase Rule
//===================================================================
package Ex6_2_1
    
    model Ex6_2_1_1
        //Pure liquid water
        //=============
        // Parameter Section
        parameter Real pi = 1 "Number of phases"; 
        parameter Real c = 1 "Number of components";    
        
        //=============
        // Variable Section 	
        Real DF "Degrees of freedom";
        
        //=============
        // Equation Section 
        equation
            DF = c + 2 - pi;
                            
    end Ex6_2_1_1;
    //===================================================================
    
    model Ex6_2_1_2
        //Liquid solid and vapour water
        //=============
        // Parameter Section
        parameter Real pi = 3 "Number of phases";
        parameter Real c = 1 "Number of components";    
        
        //=============
        // Variable Section 	
        Real DF "Degrees of freedom";
        
        //=============
        // Equation Section 
        equation
            DF = c + 2 - pi;
                            
    end Ex6_2_1_2;
    //===================================================================
    
    model Ex6_2_1_3
        //Vapour liquid mixture of acetone and methyl ethyl ketone
        //=============
        // Parameter Section
        parameter Real pi = 2 "Number of phases";
        parameter Real c = 2 "Number of components";    
        
        //=============
        // Variable Section 	
        Real DF "Degrees of freedom";
        
        //=============
        // Equation Section 
        equation
            DF = c + 2 - pi;
                            
    end Ex6_2_1_3;
    //===================================================================

end Ex6_2_1;
//===================================================================
