//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.3-3 Page 254
//Title: "Humid air at 75 degC..."
//===================================================================
model Ex6_3_3
    //=============
    // Parameter Section
    parameter Real T (unit = "degC") = 75 "Temperature of the system";
    parameter Real h_r (unit = "%") = 30 "Relative humidity of the system";
    parameter Real p_star_H2O (unit = "mmHg") = 289 "Pure component vapour pressure of watre at 75 degC"; // From Table B.3 Appendix B
    parameter Real P (unit = "bar") = 1.1 "Pressure of the feed";
    parameter Real R (unit = "m^3 bar / kmol K") = 0.0831 "Gas constant";
    parameter Real V_dot (unit = "m^3/h") = 1000 "Volumetric flow rate of wet air";
    parameter Real y_O2 = 0.21 "Mole fraction of H2O in vapour phase";
    //=============
    // Variable Section 	
    Real p_H2O (unit = "mmHg") "Partial pressure of water in the stream";
    Real y_H2O "Mole fraction of H2O in vapour phase";
    Real n_dot (unit = "kmol/h") "Molar flow rate of wet air";
    Real n_dot_H2O (unit = "kmol/h") "Molar flow rate of water";
    Real n_dot_BDA (unit = "kmol/h") "Molar flow rate of bone dry air";
    Real n_dot_O2 (unit = "kmol/h") "Molar flow rate of oxygen";
    Real h_m (unit = "mol H2O / mol BDA") "Molar humidity of the air";
    Real h_m_star (unit = "mol H2O / mol BDA") "Saturated molar humidity of the air";
    Real h_a (unit = "kg H2O / kg BDA") "Absolute humidity of the air";
    Real h_p (unit = "%") "Percentage humidity of the air";
    Real T_dp (unit = "degC") "Dew point temperature of the stream";
    
    //=============
    // Equation Section 
    equation
        h_r/100 = p_H2O/ p_star_H2O;
        y_H2O = p_H2O / (P * 760 / 1.01325); //Raoult's Law
        n_dot = P * V_dot / R/ (T+273.15);
        n_dot_H2O = n_dot * y_H2O;
        n_dot_O2 = n_dot_BDA * y_O2;
        n_dot_BDA = n_dot * (1-y_H2O);
        h_m = p_H2O / ((P * 760 / 1.01325) - p_H2O);
        h_a = h_m * 18 / 29; 
        h_m_star = p_star_H2O / ((P * 760 / 1.01325) - p_star_H2O);
        h_p = 100 * h_m / h_m_star;
        T_dp = 48.7; //From Table B.3 Appendix B for p_H2O = 86.7 mmHg
        
end Ex6_3_3;
//===================================================================