//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.6-2 Page 272
//Title: Extraction of Acetone from water: Use of phase diagram
//===================================================================
model Ex6_6_2
    //=============
    // Parameter Section
    parameter Real m (unit = "kg") = 1000 "Mass of feed";
    parameter Real xA (unit = "kg A/ kg") = 0.3 "Mass fraction of acetone in feed";
    parameter Real xW (unit = "kg W/ kg") = 0.7 "Mass fraction of water in feed";
    parameter Real xA_E (unit = "kg A/ kg") = 0.10 "Mass fraction of Acetone in extract"; //From Figure 6.6-1 page 274
    parameter Real xW_E (unit = "kg W/ kg") = 0.03 "Mass fraction of water in extract"; //From Figure 6.6-1 page 274
    parameter Real xS_E (unit = "kg S/ kg") = 0.87 "Mass fraction of MIBK in extract"; //From Figure 6.6-1 page 274
    parameter Real xA_R (unit = "kg A/ kg") = 0.05 "Mass fraction of Acetone in raffinate"; //From Figure 6.6-1 page 274
    parameter Real xS_R (unit = "kg S/ kg") = 0.02 "Mass fraction of Acetone in raffinate"; //From Figure 6.6-1 page 274
    parameter Real xW_R (unit = "kg W/ kg") = 0.93 "Mass fraction of Acetone in raffinate"; //From Figure 6.6-1 page 274
    
    
    //=============
    // Variable Section 	
    Real ms (unit = "kg") "Mass of MIBK required";
    Real mE (unit = "kg") "Mass of MIBK rich phase";
    Real mR (unit = "kg") "Mass of H2O rich phase";
    
    //=============
    // Equation Section 
    equation
        ms + m = mE + mR; //Overall mass balance
        xA * m = xA_E * mE + xA_R * mR; //Acetone balance
        xW * m = xW_E * mE + xW_R * mR; //Water balance
        
end Ex6_6_2;