//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.4-1 Page 322
//Title: Calculation of Enthalpy
//===================================================================
model Ex7_4_1
    //=============
    // Parameter Section
    parameter Real U_cap (unit = "J/mol") = 3800 "Specific Internal Energy of Helium";
    parameter Real P (unit = "atm") = 1 "Pressure of Helium";
    parameter Real V_cap (unit = "L/mol") = 24.63 "Specific Volume of Helium";
    parameter Real n_dot (unit = "kmol/h") = 250 "Molar flow rate of Helium";
        
    //=============
    // Variable Section 	
    Real H_cap (unit = "J/mol") "Specific Enthalpy of Helium";
    Real H_dot (unit = "J/h") "Enthalpy rate";
    
    //=============
    // Equation Section 
    equation
        H_cap = U_cap + (P * V_cap * 8.314 / 0.08206);
        H_dot = n_dot * 1e3 * H_cap;
end Ex7_4_1;