//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.5-3 Page 329
//Title: Energy Balance on Steam Turbine
//===================================================================
model Ex7_5_3
    //=============
    // Parameter Section
    parameter Real T_superheat (unit = "degC") = 190 "Degrees of superheat";
    parameter Real P (unit = "bara") = 10 "Absolute pressure of steam";
    parameter Real T_sat (unit = "degC") = 180 "Temperature of saturation of steam at given pressure"; //Taken from table B.7
    parameter Real m_dot (unit = "kg/h") = 2000 "Mass flow rate of steam";
    
    //=============
    // Variable Section 	
    Real T_inlet (unit = "degC") "Inlet temperature of steam";
    Real Hcap_in (unit = "kJ/kg") "Specific enthalpy of inlet steam";
    Real Hcap_out (unit = "kJ/kg") "Specific enthalpy of outlet steam";
    Real Ws_dot (unit = "kW") "Work output of turbine";        
        
    //=============
    // Equation Section 
    equation
        T_inlet = T_sat + T_superheat;
        Hcap_in = 3201; //Interpolated value from Table B.7
        Hcap_out = 2675; //Enthalpy of saturated steam at 1 bara from Table B.7 
        Ws_dot = -m_dot * (Hcap_out - Hcap_in) / 3600;
                
end Ex7_5_3;