//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.6-1 Page 330
//Title: Energy Balance on a One-Component Process
//===================================================================
model Ex7_6_1
    //=============
    // Parameter Section
    parameter Real m1 (unit = "kg/min") = 120 "Inlet mass flow rate of stream 1";
    parameter Real m2 (unit = "kg/min") = 175 "Inlet mass flow rate of stream 2";
    parameter Real Hcap1 (unit = "kJ/kg") = 125.7 "Specific enthalpy of stream 1"; //From Table B.5 and B.6
    parameter Real Hcap2 (unit = "kJ/kg") = 271.9 "Specific enthalpy of stream 2";//From Table B.5 and B.6
    parameter Real Hcap_out (unit = "kJ/kg") = 2793 "Specific enthalpy of outlet stream";
    parameter Real d (unit = "cm") = 6 "ID of outlet pipe";
    parameter Real Vcap (unit = "m^3/kg") = 0.1166 "Specific volume of steam";
    import Modelica.Constants.pi;
    
    //=============
    // Variable Section 	
    Real delH_dot (unit = "kJ/min") "Enthalpy change occuring in the boiler";
    Real Qdot (unit = "kJ/min") "Heat input required";
    Real A (unit = "m^2") "Area of cross section of pipe";
    Real m_out (unit = "kg/s") "Mass flow rate of steam in outlet";
    Real u (unit = "m/s") "Outlet velocity of steam";
    Real delEk (unit = "kJ / min") "Change in kinetic energy of streams";    
    
    //=============
    // Equation Section 
    equation
        m_out = m1 + m2;
        delH_dot = (m_out*Hcap_out) - (m1*Hcap1 + m2*Hcap2);
        A = pi / 4 * d^2 / 1e4;
        u = m_out * Vcap / 60 / A;
        delEk = m_out * u^2 / 2 /1000;
        Qdot = delH_dot + delEk;
        
end Ex7_6_1;