//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-3 Page 382
//Title: Estimation of a Heat of Vaporisation
//===================================================================
model Ex8_4_3
    //=============
    // Parameter Section
    parameter Real T_bp (unit = "K") = 337.9 "Normal Boiling point of methanol";
    parameter Real T_c (unit = "K") = 513.2 "Critical temperature of methanol";
    
    //=============
    // Variable Section
    Real delHcap_v (unit = "kJ/mol") "Enthalpy of vaporisation of methanol at normal boiling point";
    Real delHcap_v_200 (unit = "kJ/mol") "Enthalpy of vaporisation of methanol at 200 degC";
    
    //=============
    // Equation Section 
    equation
        delHcap_v = 0.109 * T_bp; //Trouton's rule
        delHcap_v_200 = delHcap_v * ((T_c - (200 + 273.15)) / (T_c - T_bp))^0.38; //Watson's rule
        
end Ex8_4_3;
//===================================================================