//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-5 Page 389
//Title: The Psychrometric Chart
//===================================================================
package Ex8_4_5
    model Ex8_4_5_2
        //=============
        // Parameter Section
        parameter Real V (unit = "m^3") = 150 "Volume of air";
        
        //=============
        // Variable Section
        Real m (unit = "kg") "Mass of water contained in air";
        Real V_h (unit = "m^3/kg") "Humid volume of air";
        Real h_a (unit = "kg H2O / kg DA") "Humidity of air";
        
        //=============
        // Equation Section 
        equation
            h_a = 0.0048; //From Figure 8-4.1 page 385
            V_h = 0.897; //From Figure 8-4.1 page 385
            m = V / V_h * h_a;
            
    end Ex8_4_5_2;
end Ex8_4_5;
//===================================================================