//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-7 Page 393
//Title: Adiabatic Humidification
//===================================================================
package Ex8_4_7
    model Ex8_4_7_2
        //=============
        // Parameter Section
        parameter Real Ha_out (unit = "kg H2O/ kg DA") = 0.0063 "Absolute humidity of leaving air"; //Figure 8.4-1 page 387
        parameter Real Ha_in (unit = "kg H2O/ kg DA") = 0.0026 "Absolute humidity of entering air"; //Figure 8.4-1 page 387
        parameter Real m_dot (unit = "kg/h") = 1000 "Mass flow rate of air";
        
        //=============
        // Variable Section
        Real m_dot_DA (unit = "kg DA/h") "Mass flow rate of dry air";
        Real m_dot_H2O (unit = "kg H2O /h") "Rate of addition of water";
        Real T_exit (unit = "degC") "Exit temperature of humid air";
        
        //=============
        // Equation Section 
        equation
            m_dot_DA = m_dot / (1 + Ha_in);
            m_dot_H2O = m_dot_DA * (Ha_out - Ha_in);
            T_exit = 21.2; //Figure 8.4-1 page 387
            
    end Ex8_4_7_2;
    //===================================================================
end Ex8_4_7;
