//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.1-1 Page 443
//Title: Calculation of Heats of Reaction
//===================================================================
package Ex9_1_1
    model Ex9_1_1_1
        //=============
        // Parameter Section
        parameter Real delHr (unit = "kJ/mol") = -2878 "Enthalpy of reaction";
        parameter Real n_dot_CO2 (unit = "mol/s") = 2400 "Rate of production of CO2";
        parameter Real nu_CO2 = 4 "Stoichiometric coefficient of CO2 in reaction"; //from the reaction
        
        //=============
        // Variable Section
        Real delH_dot (unit = "kJ/s") "Rate of enthalpy change";
        Real epsilon_dot (unit = "mol/s") "Extent of reaction";
        
        //=============
        // Equation Section 
        equation
            epsilon_dot = n_dot_CO2 / nu_CO2;
            delH_dot = epsilon_dot * delHr;    
                        
    end Ex9_1_1_1;
    //===================================================================
    model Ex9_1_1_2
        //=============
        // Parameter Section
        parameter Real delHr1 (unit = "kJ/mol") = -2878 "Enthalpy of reaction";
        parameter Real n_dot_CO2 (unit = "mol/s") = 2400 "Rate of production of CO2";
        parameter Real nu_CO2 = 8 "Stoichiometric coefficient of CO2 in reaction"; //from the reaction
        
        //=============
        // Variable Section
        Real delHr2 (unit = "kJ/mol") "Enthalpy of reaction for new reaction equation";
        Real delH_dot (unit = "kJ/s") "Rate of enthalpy change";
        Real epsilon_dot (unit = "mol/s") "Extent of reaction";
        
        //=============
        // Equation Section 
        equation
            delHr2 = 2* delHr1;
            epsilon_dot = n_dot_CO2 / nu_CO2;
            delH_dot = epsilon_dot * delHr2;    
                        
    end Ex9_1_1_2;
    //===================================================================
model Ex9_1_1_3
    //=============
    // Parameter Section
    parameter Real delHr1 (unit = "kJ/mol") = -2878 "Enthalpy of reaction";
    parameter Real n_dot_CO2 (unit = "mol/s") = 2400 "Rate of production of CO2";
    parameter Real nu_CO2 = 4 "Stoichiometric coefficient of CO2 in reaction"; //from the reaction
    parameter Real delHv_H2O (unit = "kJ/mol") = 44 "Enthalpy of vaporisation of H2O";
    parameter Real delHv_C4H10 (unit = "kJ/mol") = 19.2 "Enthalpy of vaporisation of C4H10";
    
    //=============
    // Variable Section
    Real delHr2 (unit = "kJ/mol") "Enthalpy of reaction for new reaction equation";
    Real delH_dot (unit = "kJ/s") "Rate of enthalpy change";
    Real epsilon_dot (unit = "mol/s") "Extent of reaction";
    
    //=============
    // Equation Section 
    equation
        delHr2 = delHr1 + 5*delHv_H2O + delHv_C4H10;
        epsilon_dot = n_dot_CO2 / nu_CO2;
        delH_dot = epsilon_dot * delHr2;    
                    
end Ex9_1_1_3;
    //===================================================================
end Ex9_1_1;
//===================================================================
