//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.1-2 Page 445
//Title: Evaluation of delUcapr
//===================================================================
model Ex9_1_2
    //=============
    // Parameter Section
    parameter Real delHcap_r_o (unit = "kJ/mol") = -420.8 "Standard Enthalpy of reaction";
    parameter Real R (unit = "J/mol K") = 8.314 "Gas constant";
    parameter Real T (unit = "K") = 298 "Temperature";
    
    //=============
    // Variable Section
    Real delUcap_r (unit = "kJ/mol") "Standard Internal energy change of reaction";
    Real nu_p "Sum of stoichiometric coefficients of products";
    Real nu_r "Sum of stoichiometric coefficients of reactants";    
    
    //=============
    // Equation Section 
    equation
         nu_p = 2; //From reaction C2H4 + 2Cl2 -> C2HCl3 + H2 + HCl
         nu_r = 3; //From reaction C2H4 + 2Cl2 -> C2HCl3 + H2 + HCl
         delUcap_r = delHcap_r_o - (R/1000)*T*(nu_p - nu_r);
         
end Ex9_1_2;