//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.3-1 Page 447
//Title: Determination of a Heat of Reaction from Heats of Formation
//===================================================================
model Ex9_3_1
    //=============
    // Parameter Section
    parameter Real delHcap_f_CO2 (unit = "kJ/mol") = -393.5 "Standard Enthalpy of formation of CO2";
    parameter Real delHcap_f_H2O (unit = "kJ/mol") = -285.84 "Standard Enthalpy of formation of H2O";
    parameter Real delHcap_f_C5H12 (unit = "kJ/mol") = -173 "Standard Enthalpy of formation of C5H12";
    //Heats of formation taken from Table B.1 page 628
    
    //=============
    // Variable Section
    Real delHcap_r_o (unit = "kJ/mol") "Standard Enthalpy of reaction";
    
    //=============
    // Equation Section 
    equation
         delHcap_r_o = 5*delHcap_f_CO2 + 6*delHcap_f_H2O - delHcap_f_C5H12;
         
end Ex9_3_1;