//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.4-1 Page 449
//Title: Calculation of a Heat ofReactionfrom Heats of Combustion
//===================================================================
model Ex9_4_1
    //=============
    // Parameter Section
    parameter Real delHcap_c_C2H6 (unit = "kJ/mol") = -1559.9 "Standard Enthalpy of combustion of C2H6";
    parameter Real delHcap_c_C2H4 (unit = "kJ/mol") = -1411 "Standard Enthalpy of combustion of C2H4";
    parameter Real delHcap_c_H2 (unit = "kJ/mol") = -285.84 "Standard Enthalpy of combustion of H2";
    
    //=============
    // Variable Section
    Real delHcap_r_o (unit = "kJ/mol") "Standard Enthalpy of reaction";
    
    //=============
    // Equation Section 
    equation
         delHcap_r_o = delHcap_c_C2H6 - delHcap_c_C2H4 - delHcap_c_H2;
         
end Ex9_4_1;