//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.1 Pg 303
//Title: Steady state conduction.
//================================================================================================

model Ex10_1
//===================
// Parameter Section
parameter Real A(unit="ft^2")=25            "Area of the wall";
parameter Real T1(unit="F")=40              "Temperature on the cold side";
parameter Real T2(unit="F")=180             "Temperature on the hot side";
parameter Real x(unit="ft")=0.5             "Thickness of pulverized cork";
parameter Real K1(unit="Btu/ft.h.F")=0.021  "Thermal conductivity of the cork at 32F";
parameter Real K2(unit="Btu/ft.h.F")=0.032  "Thermal conductivity of the cork at 200F";

//===================
// Variable Section
Real q(unit="Btu/h")         "Rate of heat flow";
Real Tavg(unit="F")          "Average temperature";
Real K3(unit="Btu/ft.h.F")   "Thermal conductivity at 110 F";
Real deltaT(unit="F")        "Temperature difference";

//==================
//Equation  Section 
equation
deltaT=T2-T1;
Tavg=(T1+T2)/2;
K3= K1+ ((110-32)*(K2-K1))/(200-32);
q= (K3*A*deltaT)/x;

end Ex10_1;
