//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.3 Pg 307
//Title: Steady state conduction.
//============================================================================================

model Ex10_3
//===================
// Parameter Section
parameter Real L(unit="m")=1                "Length is assumed";
parameter Real Ti(unit="C")=150             "Temperature on the outer side of pipe";
parameter Real To(unit="C")=30              "Temperature on the outer side of cork";
parameter Real D1(unit="mm")=60             "Outer diameter of tube";
parameter Real x1(unit="mm")=50             "Length of silica layer";
parameter Real x2(unit="mm")=40             "Length of cork layer";
parameter Real k1(unit="W/m C")=0.055       "Thermal conductivity of silica foam";
parameter Real k2(unit="W/m.C")=0.05        "Thermal conductivity of cork ";

//===================
// Variable Section
Real rl1(unit="mm")        "Log mean radius for silica layer";
Real rl2(unit="mm")        "Log mean radius for cork layer";
Real AA(unit="m^2")        "Area of silica layer";
Real AB(unit="m^2")        "Area of cork layer";
Real q(unit="W/m")         "Heat loss";

//==================
//Equation  Section 
equation
rl1= (80-30)/log(80/30);
rl2= (120-80)/log(120/80);
AA= 2*3.1415*(rl1*10^(-3))*L;
AB= 2*3.1415*(rl2*10^(-3))*L;
//q1= A1*K1*(T1-Tx)/0.05 = 0.3522(T1-Tx)
//q2= K2*A2*(Tx-T2)/0.04 = 0.7748(Tx-T2)
//Add q1 and q2. And q1=q2. This gives  (4.13*q/L)=T1-T2.
(4.13*q/L)=Ti-To;  

end Ex10_3;
