//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.5 Pg 316
//Title: Unsteady state conduction.
//============================================================================================

package Ex10_5
model Ex10_5_1
//===================
// Parameter Section
parameter Real Ta(unit="C")=80             "Temperature at the beginning";
parameter Real Tf(unit="C")=30             "Air temperature";
parameter Real rho(unit="Kg/m^3")=1100     "Density of solid";
parameter Real Cp(unit="J/Kg.K")=1700      "Specific heat of solid";
parameter Real k(unit="W/m.C")=0.13        "Thermal conductivity of solid ";
parameter Real Fo(unit="nil")=1.06         "Fourier number"; //From Fig 10.8 Pg315 
parameter Real Fo1(unit="nil")=0.19        "Fourier number"; //From Fig 10.8 Pg315 for Bi=infintiy
parameter Real h(unit="W/m^2")=50          "External heat transfer coefficient";
parameter Real d(unit="m")=5*10^(-3)       "Diameter of plastic spheres";
parameter Real rm(unit="m")=2.5*10^(-3)    "Radius of sphere";

//===================
// Variable Section
Real U(unit="W/m^2.C")        "Overall resistance";
Real Bi(unit="nil")           "Biot number";
Real alpha(unit="m^2/s")      "Thermal diffusivity";
Real t(unit="s")              "Time required";
Real t1(unit="s")             "Time required";

//==================
//Equation  Section 
equation
(1/U)= (1/h)+ (rm/(5*k));
Bi=(h*rm)/k;
alpha= k/(rho*Cp);
t= Fo*rm^2/alpha;
t1= -log(5/50)*(1100*(1.7*10^3)*rm)/(3*U);

end Ex10_5_1;

model Ex10_5_2
//===================
// Parameter Section
parameter Real Ta(unit="C")=80             "Temperature at the beginning";
parameter Real Tf(unit="C")=30             "Air temperature";
parameter Real rho(unit="Kg/m^3")=1100     "Density of solid";
parameter Real Cp(unit="J/Kg.K")=1700      "Specific heat of solid";
parameter Real k(unit="W/m.C")=0.13        "Thermal conductivity of solid ";
parameter Real Fo(unit="nil")=1.06         "Fourier number"; //From Fig 10.8 Pg315 
parameter Real Fo1(unit="nil")=0.19        "Fourier number"; //From Fig 10.8 Pg315 for Bi=infintiy
parameter Real h(unit="W/m^2")=50          "External heat transfer coefficient";
parameter Real d(unit="m")=5*10^(-3)       "Diameter of plastic spheres";
parameter Real rm(unit="m")=2.5*10^(-3)    "Radius of sphere";

//===================
// Variable Section
Real x(unit="nil")            "Variable used to show fraction of external resistance";
// x=U/h.
Real U(unit="W/m^2.C")        "Overall resistance";

//==================
//Equation  Section 
equation

(1/U)= (1/h)+ (rm/(5*k));
x=U/h;


end Ex10_5_2;

model Ex10_5_3
//===================
// Parameter Section
parameter Real Ta(unit="C")=80             "Temperature at the beginning";
parameter Real Tf(unit="C")=30             "Air temperature";
parameter Real rho(unit="Kg/m^3")=1100     "Density of solid";
parameter Real Cp(unit="J/Kg.K")=1700      "Specific heat of solid";
parameter Real k(unit="W/m.C")=0.13        "Thermal conductivity of solid ";
parameter Real Fo(unit="nil")=1.06         "Fourier number"; //From Fig 10.8 Pg315 
parameter Real Fo1(unit="nil")=0.19        "Fourier number"; //From Fig 10.8 Pg315 for Bi=infintiy
parameter Real h(unit="W/m^2")=50          "External heat transfer coefficient";
parameter Real d(unit="m")=5*10^(-3)       "Diameter of plastic spheres";
parameter Real rm(unit="m")=2.5*10^(-3)    "Radius of sphere";

//===================
// Variable Section
Real t2(unit="s")             "Time required";
Real alpha(unit="m^2/s")      "Thermal diffusivity";

//==================
//Equation  Section 
equation
alpha= k/(rho*Cp);
t2= (Fo1*rm^2)/alpha;



end Ex10_5_3;



end Ex10_5;
