//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.6 Pg 318
//Title: Unsteady state conduction.
//============================================================================================

model Ex10_6
//===================
// Parameter Section
parameter Real Ta(unit="F")=70               "Initial temperature";
parameter Real Ts(unit="F")=250              "Temperature at which the plate is kept";
parameter Real Tb(unit="F")=210              "Final temperature";
parameter Real rho(unit="lb/ft^3")=56.2      "Density of solid";
parameter Real Cp(unit="Btu/lb.F")=0.40      "Specific heat of solid";
parameter Real k(unit="Btu/ft.h.F")=0.075    "Thermal conductivity of solid ";
parameter Real Fo(unit="nil")=0.52           "Fourier number"; //From Fig 10.5 Pg311 

//===================
// Variable Section
Real s(unit="ft")             "Half thickness of slab";
Real alpha(unit="ft^2/h")     "Thermal diffusivity";
Real tT(unit="h")             "Time required";
Real QT(unit="Btu/ft^2")      "Heat transferred per unit area";

//==================
//Equation  Section 
equation
s=0.5/12;
alpha= k/(rho*Cp);
tT= Fo*s^2/alpha;
QT=s*rho*Cp*(Tb-Ta);

end Ex10_6;
