//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.6 Pg 318
//Title: Unsteady state conduction.
//============================================================================================

model Ex10_7
//===================
// Parameter Section
parameter Real Ta(unit="C")=5               "Initial temperature";
parameter Real Ts(unit="C")=(-20)           "Temperature at which the plate is kept";
parameter Real T(unit="C")=0                "Final temperature";
parameter Real t(unit="h")=48               "Time taken";
parameter Real alpha(unit="m^2/h")=0.0011   "Thermal diffusivity";
parameter Real Z(unit="nil")=0.91           "Taken from Fig10.10 Pg319.";

//===================
// Variable Section
Real x(unit="m")      "Depth";
Real xp(unit="m")     "Penetration distance";

//==================
//Equation  Section 
equation
x=Z*2*sqrt(alpha*t);
xp=3.64*sqrt(alpha*t);


end Ex10_7;
