//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 11: Principles of Heat flow in fluids.
//Example  : 11.1 Pg 341
//Title: Heat flux and heat transfer coefficients. 
//================================================================================================

model Ex11_1

//===================
// Parameter Section
parameter Real Di(unit="ft")=0.0874         "Inside Diameter";                                                
parameter Real Do(unit="ft")=0.1096         "Outside Diameter";
parameter Real xw(unit="ft")=0.0111         "Wall thickness";
//These values are taken from App3 for 1in Sc40 
parameter Real hi(unit="Btu/ft^2.h.F")=180  "Heat transfer coefficient for alcohol";
parameter Real ho(unit="Btu/ft^2.h.F")=600  "Heat transfer coefficient for water";
parameter Real hdi(unit="Btu/ft^2.h.F")=1000"Inside fouling factor";
parameter Real hdo(unit="Btu/ft^2.h.F")=500 "Outside fouling factor";
parameter Real K(unit="Btu/ft.h.F")=26      "Thermal conductivity of steel";

//===================
// Variable Section
Real DL(unit="ft")           "Logarithmic mean Diameter";
Real Uo(unit="Btu/ft^2.h.F")  "Overall heat transfer coefficient";

//==================
//Equation  Section 
equation
DL=(Do-Di)/log(Do/Di);
Uo= 1/((Do/(hdi*Di))+(Do/(hi*Di))+((xw*Do)/(K*DL))+(1/ho)+(1/hdo));

end Ex11_1;
