//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 12: Heat transfer to fluids without phase change.
//Example  : 12.3 Pg 370
//Title: Heat transfer in transition region between laminar and turbulent flow. 
//================================================================================================

model Ex12_3
extends Modelica.Constants;
//Table 12.3 isreferred for certain values.
//===================
// Parameter Section
parameter Real T1(unit="F")=150          "Initial temperature";
parameter Real T2(unit="F")=250          "Final temperature";
parameter Real Tw(unit="F")=350          "pipe wall temperature";
parameter Real k(unit="BTU/lb.F")=0.082  "Thermal conductivity";
parameter Real Cp(unit="Btu/lb.F")=0.48  "Specific heat";
parameter Real muw(unit="cP")=1.37       "Viscosity ";
parameter Real mu(unit="cP")=4.65        "Viscosity ";
parameter Real L(unit="ft")=15           "Length of pipe";

//===================
// Variable Section
Real h(unit="Btu/h.ft^2.F")     "heat transfer coefficient";
Real Re(unit="nil")             "Reynolds number";
Real Gz(unit="nil")             "Graetz number";
Real deltaTL(unit="F")          "Teperature difference";
Real fiv(unit="nil")            "Viscosity correlation factor";
Real m(unit="lb/h")             "mass flow rate";

//==================
//Equation  Section 
equation
fiv=(mu/muw)^0.14;
deltaTL=(Tw-T1-(Tw-T2))/log(200/100);
m=(4.69/0.233)^(3/2);
// few steps are missed as it cannot be coded in this software.
h=0.233*m;
Gz=(m*Cp)/(k*L);
Re=(4*m)/(pi*0.0303*3.3*2.42);

end Ex12_3;
