//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 12: Heat transfer to fluids without phase change.
//Example  : 12.4 Pg 380
//Title: Natural convection. 
//================================================================================================

model Ex12_4
//===================
// Parameter Section
parameter Real T1(unit="F")=68           "Initial temperature";
parameter Real T2(unit="F")=188          "Final temperature";
parameter Real Tw(unit="F")=220          "pipe wall temperature";
parameter Real D(unit="ft")=0.1723       "Diameter, from App.3";
parameter Real mu(unit="cP")=0.019       "Viscosity";
parameter Real k(unit="BTU/lb.F")=0.0163 "Thermal conductivity";
parameter Real Cp(unit="Btu/lb.F")=0.25  "Specific heat";
parameter Real muw(unit="cP")=0.021      "Viscosity at 220F";
parameter Real S(unit="ft^2")=0.02330    "Cross sectional area";
parameter Real V(unit="ft/s")=1.5        "Velocity";

//===================
// Variable Section
Real Tavg(unit="F")         "Temperature average";
Real rho(unit="lb/ft^3")    "Density";
Real G(unit="lb/ft^2.h")    "Mass velocity";
Real Re(unit="nil")         "Reynolds number";
Real m(unit="lb/h")         "Mass flowrate";
Real q(unit="Btu/h")        "Heat load";
Real deltaT1(unit="F")      "Temperature difference";
Real deltaT2(unit="F")      "Temperature difference";
Real deltaTl(unit="F")      "Temperature difference";
Real L(unit="ft")           "Length";
Real beta(unit="R^-1")      "Coefficient of volumetric expansion at 128F";
Real deltaT3(unit="F")      "temp. difference";
Real Gr(unit="nil")         "Grashof number";
Real FIn(unit="nil")        "Natural convection factor";
Real Lnew(unit="ft")        "Length";

//==================
//Equation  Section 
equation
Tavg=(T1+T2)/2;
rho=(29/359)*(492/(68+460));
G=V*rho*3600;
Re=(D*G)/(mu*2.42);
m=G*S;
q=m*Cp*(T2-T1);
deltaT1=220-188;
deltaT2=220-68;
deltaTl=(deltaT2-deltaT1)/log(deltaT2/deltaT1);
(0.9813/L^(1/3))=6.82/L;
//This is obtained by equating 2 relation for h. which cannot be coded here.
beta=1/(460+128); //at 128F
deltaT3=220-128;
Gr= (D^3*0.0676^2*32.174*beta*deltaT3)/(mu*6.72*10^(-4))^2;
//In T.B its given as 0.7192*10^6.Here we get 721804.
FIn=(2.25*(1+(0.01*(Gr)^(1/3))))/log10(Re);
Lnew=L/FIn;


end Ex12_4;
