//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 13: Heat transfer to fluids with phase change.
//Example  : 13.1 Pg 396
//Title: Heat transfer from condensing vapours. 
//================================================================================================

package Ex13_1
model Ex13_1_1
//===================
// Parameter Section
parameter Real d(unit="m")=0.019            "Diameter of tubes";
parameter Real lamda(unit="J/g")=324.9      "Latent heat od condensation of chlorobenzene";
parameter Real g(unit="m/s^2")=9.8          "Acceleration due to gravity";
parameter Real l(unit="m")=1.52             "Length of tubes";
parameter Real hi(unit="W/m^2.C")=4540      "Water side coefficient";
parameter Real T(unit="C")=79               "Cooling water temperature (its assumed)";
parameter Real Tw(unit="C")=90              "Wall temperature (its assumed)";
parameter Real Th(unit="C")=132             "Condensing temperature ";
parameter Real Cp(unit="J/Kg.C")=1550       "Specific heat for obtained Tf";
parameter Real rhof(unit="Kg/m^3")=1018     "Density for obtained Tf";
parameter Real Kf(unit="W/m")=0.11          "Thermal conductivity for obtained Tf";
parameter Real Kf1(unit="W/m")=0.144        "Thermal conductivity obtined from Appendix 13";
parameter Real mu(unit="Pa.s")= 3.2*10^(-4) "viscosity for obtained Tf";
parameter Real C(unit="ft^2/ft")=0.1963     "Circumference of outside diameter";
parameter Real N(unit="nil")=6              "Number of tubes in stack";
parameter Real Nu(unit="nil")=0.23          
         "Nusselt number obtained from Fig 13.2(Pg394) for a guessed Re=2000";
         
//===================
// Variable Section
Real Tf(unit="C")      "Reference temperature";
Real Pr(unit="nil")    "Prandtl number";
Real h(unit="W/m^2.C") "Heat transfer coefficient";
Real U(unit="W/m^2")   "Overall heat transfer coefficient";
Real A(unit="m^2")     "Area per tube";
Real m(unit="g/s")     "Condensate per tube";
Real Ghe(unit="Kg/m.s")"It is a notation used";
Real Re(unit="nil")    "Reynolds number";

//==================
//Equation  Section 
equation
Tf= Th-(3/4)*(Th-Tw);
Pr=(Cp*mu)/Kf;
h= (Nu*Kf)*((rhof^2*g)/mu^2)^(1/3);
(1/U)=(1/h)+(1/hi);
A= C*0.3048*l; //From Appendix 4 ,the values are taken  
m= U*A*(Th-T)/(lamda);
Ghe= m*10^(-3)/(3.14*0.019);
Re= (4*Ghe)/mu; 
//The guessed Re and calculated Re are nearly same, so Nu will not vary,so h is same

end Ex13_1_1;

model Ex13_1_2
//===================
// Parameter Section
parameter Real d(unit="m")=0.019            "Diameter of tubes";
parameter Real lamda(unit="J/g")=324.9      "Latent heat od condensation of chlorobenzene";
parameter Real g(unit="m/s^2")=9.8          "Acceleration due to gravity";
parameter Real l(unit="m")=1.52             "Length of tubes";
parameter Real hi(unit="W/m^2.C")=4540      "Water side coefficient";
parameter Real T(unit="C")=79               "Cooling water temperature (its assumed)";
parameter Real Tw(unit="C")=90              "Wall temperature (its assumed)";
parameter Real Th(unit="C")=132             "Condensing temperature ";
parameter Real Cp(unit="J/Kg.C")=1550       "Specific heat for obtained Tf";
parameter Real rhof(unit="Kg/m^3")=1018     "Density for obtained Tf";
parameter Real Kf(unit="W/m")=0.11          "Thermal conductivity for obtained Tf";
parameter Real Kf1(unit="W/m")=0.144        "Thermal conductivity obtined from Appendix 13";
parameter Real mu(unit="Pa.s")= 3.2*10^(-4) "viscosity for obtained Tf";
parameter Real C(unit="ft^2/ft")=0.1963     "Circumference of outside diameter";
parameter Real N(unit="nil")=6              "Number of tubes in stack";
parameter Real Nu(unit="nil")=0.23          
         "Nusselt number obtained from Fig 13.2(Pg394) for a guessed Re=2000";
         
//===================
// Variable Section
Real h1(unit="W/m^2.C")"Heat transfer coefficient for horizontal condensor";

//==================
//Equation  Section 
equation
h1=0.729*((Kf1^3*rhof^2*g*lamda*1000)/(N*d*mu*(132-79)))^(1/4);

end Ex13_1_2;


end Ex13_1;
