//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 13: Heat transfer to fluids with phase change.
//Example  : 13.2 Pg 408
//Title: Heat transfer to boiling liquids. 
//================================================================================================

package Ex13_2
model Ex13_2_1
//===================
// Parameter Section
  
//The properties of benzene are taken from table 13.1 Pg408
parameter Real T(unit="K")=353                    "Temperature";
parameter Real M(unit="Kg/Kmol")=78.1             "Molecular weight";
parameter Real R(unit="l.atm/Kmol.K")=0.082056    "Gas constant";
parameter Real P(unit="atm")=1                    "Pressure";
parameter Real sigma(unit="N/m")=21.5*10^(-3)     "Surface tension";
parameter Real lamda(unit="J/Kg")=395000          "Latent heat of vapourisation";
parameter Real g(unit="m/s^2")=9.8                "Acceleration due to gravity";
parameter Real sigma1(unit="N/m")=27.4*10^(-3)    "Surface tension at 308 K";
parameter Real sigma2(unit="N/m")=13.7*10^(-3)    "Surface tension at 415 K";
parameter Real T1(unit="K")=308                   "Temperature";
parameter Real T2(unit="K")=415                   "Temperature";
parameter Real P1(unit="atm")=0.2                 "Pressure";
parameter Real P2(unit="atm")=5                   "Pressure";
parameter Real lamda1(unit="J/Kg")=429000         "Latent heat of vapourisation";
parameter Real lamda2(unit="J/Kg")=349000         "Latent heat of vapourisation";

//===================
// Variable Section
Real rhov(unit="Kg/m^3")     "Density ";
Real hf(unit="W/m^2")        "Maximum heat flux"; //hf is used as q/v cant be given as variable. 


//==================
//Equation  Section 
equation
rhov= P*M/(R*T);
hf=0.12*395000*(rhov)^(1/2)*(sigma*g*813)^(1/4); 
//The T.B value is 2.82*10^5.Here we get 281579 due to round off error.
//rhol-rhov=816-3=813 & coefficient=0.12 for horizontal cylinders

end Ex13_2_1;

model Ex13_2_2
//===================
// Parameter Section
  
//The properties of benzene are taken from table 13.1 Pg408
parameter Real T(unit="K")=353                    "Temperature";
parameter Real M(unit="Kg/Kmol")=78.1             "Molecular weight";
parameter Real R(unit="l.atm/Kmol.K")=0.082056    "Gas constant";
parameter Real P(unit="atm")=1                    "Pressure";
parameter Real sigma(unit="N/m")=21.5*10^(-3)     "Surface tension";
parameter Real lamda(unit="J/Kg")=395000          "Latent heat of vapourisation";
parameter Real g(unit="m/s^2")=9.8                "Acceleration due to gravity";
parameter Real sigma1(unit="N/m")=27.4*10^(-3)    "Surface tension at 308 K";
parameter Real sigma2(unit="N/m")=13.7*10^(-3)    "Surface tension at 415 K";
parameter Real T1(unit="K")=308                   "Temperature";
parameter Real T2(unit="K")=415                   "Temperature";
parameter Real P1(unit="atm")=0.2                 "Pressure";
parameter Real P2(unit="atm")=5                   "Pressure";
parameter Real lamda1(unit="J/Kg")=429000         "Latent heat of vapourisation";
parameter Real lamda2(unit="J/Kg")=349000         "Latent heat of vapourisation";

//===================
// Variable Section
Real rhov1(unit="Kg/m^3")    "Density at 308 K";
Real hf1(unit="W/m^2")       "Maximum heat flux at 308 K";
Real rhov2(unit="Kg/m^3")    "Density at 415 K";
Real hf2(unit="W/m^2")       "Maximum heat flux at 415 K";

//==================
//Equation  Section 
equation
rhov1= P1*M/(R*T1);
hf1=0.12*429000*(rhov1)^(1/2)*(sigma1*g*863)^(1/4); 
//The T.B value is 1.58*10^5.Here we get 157905 due to round off error.
//rhol-rhov=863 & coefficient=0.12 for horizontal cylinders
rhov2= P2*M/(R*T2);
hf2=0.12*349000*(rhov2)^(1/2)*(sigma2*g*728.5)^(1/4); 
//The T.B value is 4.48*10^5.Here we get 445997 due to round off error.
//rhol-rhov=740-11.5=728.5 & coefficient=0.12 for horizontal cylinders

end Ex13_2_2;

end Ex13_2;
