//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 14: Radiation Heat transfer.
//Example  : 14.1 Pg 432
//Title: Radiation between surfaces. 
//================================================================================================

package Ex14_1
model Ex14_1_1
//===================
// Parameter Section
// Let 1 refers to hot plate, 2 to lacquered sheets, 3 to cold plate

parameter Real T1(unit="K")=573                     "Temperature of hot plate";
parameter Real T3(unit="K")=298                     "Temperature of cold plate";
parameter Real epsilon1(unit="nil")=0.56            "Emissivity of steel";
parameter Real epsilon3(unit="nil")=0.56            "Emissivity of steel";
parameter Real epsilon2(unit="nil")=1.00            "Emissivity of lacquered sheet";
parameter Real sigma(unit="W/m^2*K^4")=5.672*10^(-8)"Stefan-Boltzmann Constant";

//===================
// Variable Section
Real tou12(unit="nil")     "Overall interchange factor";
Real T2(unit="K")          "Temperature of lacquered sheet";

//==================
//Equation  Section 
equation

tou12= 1/((1/epsilon1)+(1/epsilon2)-1); //tou12=tou23
//q12=sigma*A1*tou12*(T1^4-T2^4).
// At equilibirium q12=q23 and A1=A2.
(T1/100)^4-(T2/100)^4= (T2/100)^4-(T3/100)^4;

end Ex14_1_1;

model Ex14_1_2
//===================
// Parameter Section
// Let 1 refers to hot plate, 2 to lacquered sheets, 3 to cold plate

parameter Real T1(unit="K")=573                     "Temperature of hot plate";
parameter Real T3(unit="K")=298                     "Temperature of cold plate";
parameter Real epsilon1(unit="nil")=0.56            "Emissivity of steel";
parameter Real epsilon3(unit="nil")=0.56            "Emissivity of steel";
parameter Real epsilon2(unit="nil")=1.00            "Emissivity of lacquered sheet";
parameter Real sigma(unit="W/m^2*K^4")=5.672*10^(-8)"Stefan-Boltzmann Constant";

//===================
// Variable Section
Real q12(unit="W/m^2")     "Heat transferrred between surface 1 and 2";
Real q23(unit="W/m^2")     "Heat transferrred between surface 2 and 3";
Real tou12(unit="nil")     "Overall interchange factor";
Real T2(unit="K")          "Temperature of lacquered sheet";

//==================
//Equation  Section 
equation

tou12= 1/((1/epsilon1)+(1/epsilon2)-1); //tou12=tou23
//q12=sigma*A1*tou12*(T1^4-T2^4).
// At equilibirium q12=q23 and A1=A2.
(T1/100)^4-(T2/100)^4= (T2/100)^4-(T3/100)^4;
q12= sigma*1*tou12*((T1)^4-(T2^4));
q23= sigma*1*tou12*((T2)^4-(T3^4));

end Ex14_1_2;

end Ex14_1;
