//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 15: Heat Exchange Equipment
//Example  : 15.2 Pg 449
//Title: Shell and tube heat exchangers. 
//================================================================================================

model Ex15_2

//The problem is same as Ex15_1. So all values are same except FG.

//===================
// Parameter Section
parameter Real Tca(unit="C")=70        "Temperature on cold side";
parameter Real Tcb(unit="C")=120       "Temperature on cold side";
parameter Real Tha(unit="C")=240       "Temperature on hot side";
parameter Real Thb(unit="C")=120       "Temperature on hot side";
parameter Real FG(unit="nil")=0.96     "Correctness factor, taken from Fig15.6(b) Pg448";

//===================
// Variable Section
Real etaH(unit="nil")         "Heating effectiveness";
Real Z(unit="nil")            "Ratio of temperature ranges";
Real deltaT1(unit="C")        "Temperature difference at shell inlet";
Real deltaT2(unit="C")        "Temperature difference at shell outlet";
Real deltaTL(unit="C")        "log mean Temperature difference";
Real deltaTbar(unit="C")      "Correct Mean temperature difference";

//==================
//Equation  Section 
equation
etaH= (Tcb-Tca)/(Tha-Tca);
Z= (Tha-Thb)/(Tcb-Tca);
deltaT1=(Tha-Tcb);
deltaT2=(Thb-Tca);
deltaTL= (deltaT1-deltaT2)/log(deltaT1/deltaT2);
deltaTbar=FG*deltaTL;


end Ex15_2;
