//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 15: Heat Exchange Equipment
//Example  : 15.4 Pg 454
//Title: Shell and tube heat exchangers. 
//================================================================================================

model Ex15_4
//===================
// Parameter Section
parameter Real Tca(unit="C")=25           "Temperature on cold side";
parameter Real Tha(unit="C")=110          "Temperature on hot side";
parameter Real Cph(unit="J/Kg.C")=2300    "Specific heat from ";
parameter Real Cpc(unit="J/Kg.C")=4180    "Specific heat from ";
parameter Real mh(unit="Kg/h")=3000       "Flowrate of hot fluid";
parameter Real mc(unit="Kg/h")=2400       "Flowrate of cold fluid";
parameter Real UA(unit="W/C")=1.65*10^7   "Overall heat transfer coefficient";
parameter Real epsilon(unit="nil")=0.78   "Effectiveness factor, taken from Fig 15.8 Pg454";

//===================
// Variable Section 
Real Rc(unit="nil")       "Thermal capacity ratio";
Real NH(unit="nil")       "Number of heat transfer units";
Real Thb(unit="C")        "Temperature";
Real Q(unit="W")          "Quantity of heat obtained";
Real Tcb(unit="C")        "Temperature";
Real deltaT1(unit="C")    "Temperature difference";
Real deltaT2(unit="C")    "Temperature difference"; 
Real deltaTL(unit="C")    "log mean Temperature difference";

//==================
//Equation  Section 
equation 
Rc=(mh*Cph/(mc*Cpc));
NH=UA/(mh*Cph);
Thb=Tha-(0.78*(Tha-Tca)); //(0.78*(Tha-Tca))=66.3
Q=mh*Cph*66.3;
Tcb=Tca+ (Q/(mc*Cpc));
deltaT1=Thb-Tca;
deltaT2=Tha-Tcb;
deltaTL= (deltaT1-deltaT2)/log(deltaT1/deltaT2);

end Ex15_4;
